/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.WarmupStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DedicatedIp
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DedicatedIp> {
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DedicatedIp.getter(DedicatedIp::ip)).setter(DedicatedIp.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()}).build();
    private static final SdkField<String> WARMUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DedicatedIp.getter(DedicatedIp::warmupStatusAsString)).setter(DedicatedIp.setter(Builder::warmupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmupStatus").build()}).build();
    private static final SdkField<Integer> WARMUP_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DedicatedIp.getter(DedicatedIp::warmupPercentage)).setter(DedicatedIp.setter(Builder::warmupPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmupPercentage").build()}).build();
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DedicatedIp.getter(DedicatedIp::poolName)).setter(DedicatedIp.setter(Builder::poolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, WARMUP_STATUS_FIELD, WARMUP_PERCENTAGE_FIELD, POOL_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ip;
    private final String warmupStatus;
    private final Integer warmupPercentage;
    private final String poolName;

    private DedicatedIp(BuilderImpl builder) {
        this.ip = builder.ip;
        this.warmupStatus = builder.warmupStatus;
        this.warmupPercentage = builder.warmupPercentage;
        this.poolName = builder.poolName;
    }

    public String ip() {
        return this.ip;
    }

    public WarmupStatus warmupStatus() {
        return WarmupStatus.fromValue(this.warmupStatus);
    }

    public String warmupStatusAsString() {
        return this.warmupStatus;
    }

    public Integer warmupPercentage() {
        return this.warmupPercentage;
    }

    public String poolName() {
        return this.poolName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmupPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DedicatedIp)) {
            return false;
        }
        DedicatedIp other = (DedicatedIp)obj;
        return Objects.equals(this.ip(), other.ip()) && Objects.equals(this.warmupStatusAsString(), other.warmupStatusAsString()) && Objects.equals(this.warmupPercentage(), other.warmupPercentage()) && Objects.equals(this.poolName(), other.poolName());
    }

    public String toString() {
        return ToString.builder((String)"DedicatedIp").add("Ip", (Object)this.ip()).add("WarmupStatus", (Object)this.warmupStatusAsString()).add("WarmupPercentage", (Object)this.warmupPercentage()).add("PoolName", (Object)this.poolName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "WarmupStatus": {
                return Optional.ofNullable(clazz.cast(this.warmupStatusAsString()));
            }
            case "WarmupPercentage": {
                return Optional.ofNullable(clazz.cast(this.warmupPercentage()));
            }
            case "PoolName": {
                return Optional.ofNullable(clazz.cast(this.poolName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DedicatedIp, T> g) {
        return obj -> g.apply((DedicatedIp)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ip;
        private String warmupStatus;
        private Integer warmupPercentage;
        private String poolName;

        private BuilderImpl() {
        }

        private BuilderImpl(DedicatedIp model) {
            this.ip(model.ip);
            this.warmupStatus(model.warmupStatus);
            this.warmupPercentage(model.warmupPercentage);
            this.poolName(model.poolName);
        }

        public final String getIp() {
            return this.ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        public final String getWarmupStatusAsString() {
            return this.warmupStatus;
        }

        @Override
        public final Builder warmupStatus(String warmupStatus) {
            this.warmupStatus = warmupStatus;
            return this;
        }

        @Override
        public final Builder warmupStatus(WarmupStatus warmupStatus) {
            this.warmupStatus(warmupStatus.toString());
            return this;
        }

        public final void setWarmupStatus(String warmupStatus) {
            this.warmupStatus = warmupStatus;
        }

        public final Integer getWarmupPercentage() {
            return this.warmupPercentage;
        }

        @Override
        public final Builder warmupPercentage(Integer warmupPercentage) {
            this.warmupPercentage = warmupPercentage;
            return this;
        }

        public final void setWarmupPercentage(Integer warmupPercentage) {
            this.warmupPercentage = warmupPercentage;
        }

        public final String getPoolName() {
            return this.poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public DedicatedIp build() {
            return new DedicatedIp(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DedicatedIp> {
        public Builder ip(String var1);

        public Builder warmupStatus(String var1);

        public Builder warmupStatus(WarmupStatus var1);

        public Builder warmupPercentage(Integer var1);

        public Builder poolName(String var1);
    }
}

