/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus;
import software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption;
import software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOptionsCopier;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeliverabilityDashboardOptionsResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, GetDeliverabilityDashboardOptionsResponse> {
    private static final SdkField<Boolean> DASHBOARD_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DashboardEnabled").getter(GetDeliverabilityDashboardOptionsResponse.getter(GetDeliverabilityDashboardOptionsResponse::dashboardEnabled)).setter(GetDeliverabilityDashboardOptionsResponse.setter(Builder::dashboardEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardEnabled").build()}).build();
    private static final SdkField<Instant> SUBSCRIPTION_EXPIRY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubscriptionExpiryDate").getter(GetDeliverabilityDashboardOptionsResponse.getter(GetDeliverabilityDashboardOptionsResponse::subscriptionExpiryDate)).setter(GetDeliverabilityDashboardOptionsResponse.setter(Builder::subscriptionExpiryDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionExpiryDate").build()}).build();
    private static final SdkField<String> ACCOUNT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountStatus").getter(GetDeliverabilityDashboardOptionsResponse.getter(GetDeliverabilityDashboardOptionsResponse::accountStatusAsString)).setter(GetDeliverabilityDashboardOptionsResponse.setter(Builder::accountStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountStatus").build()}).build();
    private static final SdkField<List<DomainDeliverabilityTrackingOption>> ACTIVE_SUBSCRIBED_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActiveSubscribedDomains").getter(GetDeliverabilityDashboardOptionsResponse.getter(GetDeliverabilityDashboardOptionsResponse::activeSubscribedDomains)).setter(GetDeliverabilityDashboardOptionsResponse.setter(Builder::activeSubscribedDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveSubscribedDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainDeliverabilityTrackingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DomainDeliverabilityTrackingOption>> PENDING_EXPIRATION_SUBSCRIBED_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PendingExpirationSubscribedDomains").getter(GetDeliverabilityDashboardOptionsResponse.getter(GetDeliverabilityDashboardOptionsResponse::pendingExpirationSubscribedDomains)).setter(GetDeliverabilityDashboardOptionsResponse.setter(Builder::pendingExpirationSubscribedDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingExpirationSubscribedDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainDeliverabilityTrackingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ENABLED_FIELD, SUBSCRIPTION_EXPIRY_DATE_FIELD, ACCOUNT_STATUS_FIELD, ACTIVE_SUBSCRIBED_DOMAINS_FIELD, PENDING_EXPIRATION_SUBSCRIBED_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeliverabilityDashboardOptionsResponse.memberNameToFieldInitializer();
    private final Boolean dashboardEnabled;
    private final Instant subscriptionExpiryDate;
    private final String accountStatus;
    private final List<DomainDeliverabilityTrackingOption> activeSubscribedDomains;
    private final List<DomainDeliverabilityTrackingOption> pendingExpirationSubscribedDomains;

    private GetDeliverabilityDashboardOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardEnabled = builder.dashboardEnabled;
        this.subscriptionExpiryDate = builder.subscriptionExpiryDate;
        this.accountStatus = builder.accountStatus;
        this.activeSubscribedDomains = builder.activeSubscribedDomains;
        this.pendingExpirationSubscribedDomains = builder.pendingExpirationSubscribedDomains;
    }

    public final Boolean dashboardEnabled() {
        return this.dashboardEnabled;
    }

    public final Instant subscriptionExpiryDate() {
        return this.subscriptionExpiryDate;
    }

    public final DeliverabilityDashboardAccountStatus accountStatus() {
        return DeliverabilityDashboardAccountStatus.fromValue(this.accountStatus);
    }

    public final String accountStatusAsString() {
        return this.accountStatus;
    }

    public final boolean hasActiveSubscribedDomains() {
        return this.activeSubscribedDomains != null && !(this.activeSubscribedDomains instanceof SdkAutoConstructList);
    }

    public final List<DomainDeliverabilityTrackingOption> activeSubscribedDomains() {
        return this.activeSubscribedDomains;
    }

    public final boolean hasPendingExpirationSubscribedDomains() {
        return this.pendingExpirationSubscribedDomains != null && !(this.pendingExpirationSubscribedDomains instanceof SdkAutoConstructList);
    }

    public final List<DomainDeliverabilityTrackingOption> pendingExpirationSubscribedDomains() {
        return this.pendingExpirationSubscribedDomains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionExpiryDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveSubscribedDomains() ? this.activeSubscribedDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingExpirationSubscribedDomains() ? this.pendingExpirationSubscribedDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeliverabilityDashboardOptionsResponse)) {
            return false;
        }
        GetDeliverabilityDashboardOptionsResponse other = (GetDeliverabilityDashboardOptionsResponse)((Object)obj);
        return Objects.equals(this.dashboardEnabled(), other.dashboardEnabled()) && Objects.equals(this.subscriptionExpiryDate(), other.subscriptionExpiryDate()) && Objects.equals(this.accountStatusAsString(), other.accountStatusAsString()) && this.hasActiveSubscribedDomains() == other.hasActiveSubscribedDomains() && Objects.equals(this.activeSubscribedDomains(), other.activeSubscribedDomains()) && this.hasPendingExpirationSubscribedDomains() == other.hasPendingExpirationSubscribedDomains() && Objects.equals(this.pendingExpirationSubscribedDomains(), other.pendingExpirationSubscribedDomains());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeliverabilityDashboardOptionsResponse").add("DashboardEnabled", (Object)this.dashboardEnabled()).add("SubscriptionExpiryDate", (Object)this.subscriptionExpiryDate()).add("AccountStatus", (Object)this.accountStatusAsString()).add("ActiveSubscribedDomains", this.hasActiveSubscribedDomains() ? this.activeSubscribedDomains() : null).add("PendingExpirationSubscribedDomains", this.hasPendingExpirationSubscribedDomains() ? this.pendingExpirationSubscribedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardEnabled": {
                return Optional.ofNullable(clazz.cast(this.dashboardEnabled()));
            }
            case "SubscriptionExpiryDate": {
                return Optional.ofNullable(clazz.cast(this.subscriptionExpiryDate()));
            }
            case "AccountStatus": {
                return Optional.ofNullable(clazz.cast(this.accountStatusAsString()));
            }
            case "ActiveSubscribedDomains": {
                return Optional.ofNullable(clazz.cast(this.activeSubscribedDomains()));
            }
            case "PendingExpirationSubscribedDomains": {
                return Optional.ofNullable(clazz.cast(this.pendingExpirationSubscribedDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DashboardEnabled", DASHBOARD_ENABLED_FIELD);
        map.put("SubscriptionExpiryDate", SUBSCRIPTION_EXPIRY_DATE_FIELD);
        map.put("AccountStatus", ACCOUNT_STATUS_FIELD);
        map.put("ActiveSubscribedDomains", ACTIVE_SUBSCRIBED_DOMAINS_FIELD);
        map.put("PendingExpirationSubscribedDomains", PENDING_EXPIRATION_SUBSCRIBED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeliverabilityDashboardOptionsResponse, T> g) {
        return obj -> g.apply((GetDeliverabilityDashboardOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private Boolean dashboardEnabled;
        private Instant subscriptionExpiryDate;
        private String accountStatus;
        private List<DomainDeliverabilityTrackingOption> activeSubscribedDomains = DefaultSdkAutoConstructList.getInstance();
        private List<DomainDeliverabilityTrackingOption> pendingExpirationSubscribedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeliverabilityDashboardOptionsResponse model) {
            super(model);
            this.dashboardEnabled(model.dashboardEnabled);
            this.subscriptionExpiryDate(model.subscriptionExpiryDate);
            this.accountStatus(model.accountStatus);
            this.activeSubscribedDomains(model.activeSubscribedDomains);
            this.pendingExpirationSubscribedDomains(model.pendingExpirationSubscribedDomains);
        }

        public final Boolean getDashboardEnabled() {
            return this.dashboardEnabled;
        }

        public final void setDashboardEnabled(Boolean dashboardEnabled) {
            this.dashboardEnabled = dashboardEnabled;
        }

        @Override
        public final Builder dashboardEnabled(Boolean dashboardEnabled) {
            this.dashboardEnabled = dashboardEnabled;
            return this;
        }

        public final Instant getSubscriptionExpiryDate() {
            return this.subscriptionExpiryDate;
        }

        public final void setSubscriptionExpiryDate(Instant subscriptionExpiryDate) {
            this.subscriptionExpiryDate = subscriptionExpiryDate;
        }

        @Override
        public final Builder subscriptionExpiryDate(Instant subscriptionExpiryDate) {
            this.subscriptionExpiryDate = subscriptionExpiryDate;
            return this;
        }

        public final String getAccountStatus() {
            return this.accountStatus;
        }

        public final void setAccountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
        }

        @Override
        public final Builder accountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
            return this;
        }

        @Override
        public final Builder accountStatus(DeliverabilityDashboardAccountStatus accountStatus) {
            this.accountStatus(accountStatus == null ? null : accountStatus.toString());
            return this;
        }

        public final List<DomainDeliverabilityTrackingOption.Builder> getActiveSubscribedDomains() {
            List<DomainDeliverabilityTrackingOption.Builder> result = DomainDeliverabilityTrackingOptionsCopier.copyToBuilder(this.activeSubscribedDomains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveSubscribedDomains(Collection<DomainDeliverabilityTrackingOption.BuilderImpl> activeSubscribedDomains) {
            this.activeSubscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copyFromBuilder(activeSubscribedDomains);
        }

        @Override
        public final Builder activeSubscribedDomains(Collection<DomainDeliverabilityTrackingOption> activeSubscribedDomains) {
            this.activeSubscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copy(activeSubscribedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeSubscribedDomains(DomainDeliverabilityTrackingOption ... activeSubscribedDomains) {
            this.activeSubscribedDomains(Arrays.asList(activeSubscribedDomains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeSubscribedDomains(Consumer<DomainDeliverabilityTrackingOption.Builder> ... activeSubscribedDomains) {
            this.activeSubscribedDomains(Stream.of(activeSubscribedDomains).map(c -> (DomainDeliverabilityTrackingOption)((DomainDeliverabilityTrackingOption.Builder)DomainDeliverabilityTrackingOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DomainDeliverabilityTrackingOption.Builder> getPendingExpirationSubscribedDomains() {
            List<DomainDeliverabilityTrackingOption.Builder> result = DomainDeliverabilityTrackingOptionsCopier.copyToBuilder(this.pendingExpirationSubscribedDomains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingExpirationSubscribedDomains(Collection<DomainDeliverabilityTrackingOption.BuilderImpl> pendingExpirationSubscribedDomains) {
            this.pendingExpirationSubscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copyFromBuilder(pendingExpirationSubscribedDomains);
        }

        @Override
        public final Builder pendingExpirationSubscribedDomains(Collection<DomainDeliverabilityTrackingOption> pendingExpirationSubscribedDomains) {
            this.pendingExpirationSubscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copy(pendingExpirationSubscribedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingExpirationSubscribedDomains(DomainDeliverabilityTrackingOption ... pendingExpirationSubscribedDomains) {
            this.pendingExpirationSubscribedDomains(Arrays.asList(pendingExpirationSubscribedDomains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingExpirationSubscribedDomains(Consumer<DomainDeliverabilityTrackingOption.Builder> ... pendingExpirationSubscribedDomains) {
            this.pendingExpirationSubscribedDomains(Stream.of(pendingExpirationSubscribedDomains).map(c -> (DomainDeliverabilityTrackingOption)((DomainDeliverabilityTrackingOption.Builder)DomainDeliverabilityTrackingOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDeliverabilityDashboardOptionsResponse build() {
            return new GetDeliverabilityDashboardOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeliverabilityDashboardOptionsResponse> {
        public Builder dashboardEnabled(Boolean var1);

        public Builder subscriptionExpiryDate(Instant var1);

        public Builder accountStatus(String var1);

        public Builder accountStatus(DeliverabilityDashboardAccountStatus var1);

        public Builder activeSubscribedDomains(Collection<DomainDeliverabilityTrackingOption> var1);

        public Builder activeSubscribedDomains(DomainDeliverabilityTrackingOption ... var1);

        public Builder activeSubscribedDomains(Consumer<DomainDeliverabilityTrackingOption.Builder> ... var1);

        public Builder pendingExpirationSubscribedDomains(Collection<DomainDeliverabilityTrackingOption> var1);

        public Builder pendingExpirationSubscribedDomains(DomainDeliverabilityTrackingOption ... var1);

        public Builder pendingExpirationSubscribedDomains(Consumer<DomainDeliverabilityTrackingOption.Builder> ... var1);
    }
}

