/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailAsyncClient;
import software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsResponse;

public class ListDeliverabilityTestReportsPublisher
implements SdkPublisher<ListDeliverabilityTestReportsResponse> {
    private final PinpointEmailAsyncClient client;
    private final ListDeliverabilityTestReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeliverabilityTestReportsPublisher(PinpointEmailAsyncClient client, ListDeliverabilityTestReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeliverabilityTestReportsPublisher(PinpointEmailAsyncClient client, ListDeliverabilityTestReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeliverabilityTestReportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeliverabilityTestReportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListDeliverabilityTestReportsPublisher resume(ListDeliverabilityTestReportsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDeliverabilityTestReportsPublisher(this.client, (ListDeliverabilityTestReportsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDeliverabilityTestReportsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDeliverabilityTestReportsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDeliverabilityTestReportsResponseFetcher
    implements AsyncPageFetcher<ListDeliverabilityTestReportsResponse> {
        private ListDeliverabilityTestReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeliverabilityTestReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeliverabilityTestReportsResponse> nextPage(ListDeliverabilityTestReportsResponse previousPage) {
            if (previousPage == null) {
                return ListDeliverabilityTestReportsPublisher.this.client.listDeliverabilityTestReports(ListDeliverabilityTestReportsPublisher.this.firstRequest);
            }
            return ListDeliverabilityTestReportsPublisher.this.client.listDeliverabilityTestReports((ListDeliverabilityTestReportsRequest)((Object)ListDeliverabilityTestReportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

