/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisFirehoseDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisFirehoseDestination> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(KinesisFirehoseDestination.getter(KinesisFirehoseDestination::iamRoleArn)).setter(KinesisFirehoseDestination.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> DELIVERY_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStreamArn").getter(KinesisFirehoseDestination.getter(KinesisFirehoseDestination::deliveryStreamArn)).setter(KinesisFirehoseDestination.setter(Builder::deliveryStreamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD, DELIVERY_STREAM_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String iamRoleArn;
    private final String deliveryStreamArn;

    private KinesisFirehoseDestination(BuilderImpl builder) {
        this.iamRoleArn = builder.iamRoleArn;
        this.deliveryStreamArn = builder.deliveryStreamArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String deliveryStreamArn() {
        return this.deliveryStreamArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseDestination)) {
            return false;
        }
        KinesisFirehoseDestination other = (KinesisFirehoseDestination)obj;
        return Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.deliveryStreamArn(), other.deliveryStreamArn());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisFirehoseDestination").add("IamRoleArn", (Object)this.iamRoleArn()).add("DeliveryStreamArn", (Object)this.deliveryStreamArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "DeliveryStreamArn": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisFirehoseDestination, T> g) {
        return obj -> g.apply((KinesisFirehoseDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String iamRoleArn;
        private String deliveryStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseDestination model) {
            this.iamRoleArn(model.iamRoleArn);
            this.deliveryStreamArn(model.deliveryStreamArn);
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getDeliveryStreamArn() {
            return this.deliveryStreamArn;
        }

        @Override
        public final Builder deliveryStreamArn(String deliveryStreamArn) {
            this.deliveryStreamArn = deliveryStreamArn;
            return this;
        }

        public final void setDeliveryStreamArn(String deliveryStreamArn) {
            this.deliveryStreamArn = deliveryStreamArn;
        }

        public KinesisFirehoseDestination build() {
            return new KinesisFirehoseDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisFirehoseDestination> {
        public Builder iamRoleArn(String var1);

        public Builder deliveryStreamArn(String var1);
    }
}

