/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to obtain deliverability metrics for a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainStatisticsReportRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<GetDomainStatisticsReportRequest.Builder, GetDomainStatisticsReportRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(GetDomainStatisticsReportRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Domain").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(GetDomainStatisticsReportRequest::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate").getter(getter(GetDomainStatisticsReportRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            START_DATE_FIELD, END_DATE_FIELD));

    private final String domain;

    private final Instant startDate;

    private final Instant endDate;

    private GetDomainStatisticsReportRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    /**
     * <p>
     * The domain that you want to obtain deliverability metrics for.
     * </p>
     * 
     * @return The domain that you want to obtain deliverability metrics for.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The first day (in Unix time) that you want to obtain domain deliverability metrics for.
     * </p>
     * 
     * @return The first day (in Unix time) that you want to obtain domain deliverability metrics for.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code>
     * that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.
     * </p>
     * 
     * @return The last day (in Unix time) that you want to obtain domain deliverability metrics for. The
     *         <code>EndDate</code> that you specify has to be less than or equal to 30 days after the
     *         <code>StartDate</code>.
     */
    public final Instant endDate() {
        return endDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainStatisticsReportRequest)) {
            return false;
        }
        GetDomainStatisticsReportRequest other = (GetDomainStatisticsReportRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDomainStatisticsReportRequest").add("Domain", domain()).add("StartDate", startDate())
                .add("EndDate", endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainStatisticsReportRequest, T> g) {
        return obj -> g.apply((GetDomainStatisticsReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDomainStatisticsReportRequest> {
        /**
         * <p>
         * The domain that you want to obtain deliverability metrics for.
         * </p>
         * 
         * @param domain
         *        The domain that you want to obtain deliverability metrics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The first day (in Unix time) that you want to obtain domain deliverability metrics for.
         * </p>
         * 
         * @param startDate
         *        The first day (in Unix time) that you want to obtain domain deliverability metrics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The last day (in Unix time) that you want to obtain domain deliverability metrics for. The
         * <code>EndDate</code> that you specify has to be less than or equal to 30 days after the
         * <code>StartDate</code>.
         * </p>
         * 
         * @param endDate
         *        The last day (in Unix time) that you want to obtain domain deliverability metrics for. The
         *        <code>EndDate</code> that you specify has to be less than or equal to 30 days after the
         *        <code>StartDate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private String domain;

        private Instant startDate;

        private Instant endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainStatisticsReportRequest model) {
            super(model);
            domain(model.domain);
            startDate(model.startDate);
            endDate(model.endDate);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDomainStatisticsReportRequest build() {
            return new GetDomainStatisticsReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
