/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.IdentityInfo;
import software.amazon.awssdk.services.pinpointemail.model.IdentityInfoListCopier;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEmailIdentitiesResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, ListEmailIdentitiesResponse> {
    private static final SdkField<List<IdentityInfo>> EMAIL_IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EmailIdentities").getter(ListEmailIdentitiesResponse.getter(ListEmailIdentitiesResponse::emailIdentities)).setter(ListEmailIdentitiesResponse.setter(Builder::emailIdentities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailIdentities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEmailIdentitiesResponse.getter(ListEmailIdentitiesResponse::nextToken)).setter(ListEmailIdentitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<IdentityInfo> emailIdentities;
    private final String nextToken;

    private ListEmailIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.emailIdentities = builder.emailIdentities;
        this.nextToken = builder.nextToken;
    }

    public boolean hasEmailIdentities() {
        return this.emailIdentities != null && !(this.emailIdentities instanceof SdkAutoConstructList);
    }

    public List<IdentityInfo> emailIdentities() {
        return this.emailIdentities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEmailIdentitiesResponse)) {
            return false;
        }
        ListEmailIdentitiesResponse other = (ListEmailIdentitiesResponse)((Object)obj);
        return Objects.equals(this.emailIdentities(), other.emailIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEmailIdentitiesResponse").add("EmailIdentities", this.emailIdentities()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailIdentities": {
                return Optional.ofNullable(clazz.cast(this.emailIdentities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEmailIdentitiesResponse, T> g) {
        return obj -> g.apply((ListEmailIdentitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private List<IdentityInfo> emailIdentities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEmailIdentitiesResponse model) {
            super(model);
            this.emailIdentities(model.emailIdentities);
            this.nextToken(model.nextToken);
        }

        public final Collection<IdentityInfo.Builder> getEmailIdentities() {
            return this.emailIdentities != null ? (Collection)this.emailIdentities.stream().map(IdentityInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder emailIdentities(Collection<IdentityInfo> emailIdentities) {
            this.emailIdentities = IdentityInfoListCopier.copy(emailIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailIdentities(IdentityInfo ... emailIdentities) {
            this.emailIdentities(Arrays.asList(emailIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailIdentities(Consumer<IdentityInfo.Builder> ... emailIdentities) {
            this.emailIdentities(Stream.of(emailIdentities).map(c -> (IdentityInfo)((IdentityInfo.Builder)IdentityInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEmailIdentities(Collection<IdentityInfo.BuilderImpl> emailIdentities) {
            this.emailIdentities = IdentityInfoListCopier.copyFromBuilder(emailIdentities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEmailIdentitiesResponse build() {
            return new ListEmailIdentitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEmailIdentitiesResponse> {
        public Builder emailIdentities(Collection<IdentityInfo> var1);

        public Builder emailIdentities(IdentityInfo ... var1);

        public Builder emailIdentities(Consumer<IdentityInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

