/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IdentityType {
    EMAIL_ADDRESS("EMAIL_ADDRESS"),
    DOMAIN("DOMAIN"),
    MANAGED_DOMAIN("MANAGED_DOMAIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IdentityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IdentityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IdentityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IdentityType> knownValues() {
        return Stream.of(IdentityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

