/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to list all of the predictive inbox placement tests that you've performed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeliverabilityTestReportsRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<ListDeliverabilityTestReportsRequest.Builder, ListDeliverabilityTestReportsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDeliverabilityTestReportsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListDeliverabilityTestReportsRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PAGE_SIZE_FIELD));

    private final String nextToken;

    private final Integer pageSize;

    private ListDeliverabilityTestReportsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in
     * the list of predictive inbox placement tests.
     * </p>
     * 
     * @return A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the
     *         position in the list of predictive inbox placement tests.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of
     * results is larger than the number you specified in this parameter, then the response includes a
     * <code>NextToken</code> element, which you can use to obtain additional results.
     * </p>
     * <p>
     * The value you specify has to be at least 0, and can be no more than 1000.
     * </p>
     * 
     * @return The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the
     *         number of results is larger than the number you specified in this parameter, then the response includes a
     *         <code>NextToken</code> element, which you can use to obtain additional results.</p>
     *         <p>
     *         The value you specify has to be at least 0, and can be no more than 1000.
     */
    public Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliverabilityTestReportsRequest)) {
            return false;
        }
        ListDeliverabilityTestReportsRequest other = (ListDeliverabilityTestReportsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDeliverabilityTestReportsRequest").add("NextToken", nextToken()).add("PageSize", pageSize())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeliverabilityTestReportsRequest, T> g) {
        return obj -> g.apply((ListDeliverabilityTestReportsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDeliverabilityTestReportsRequest> {
        /**
         * <p>
         * A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position
         * in the list of predictive inbox placement tests.
         * </p>
         * 
         * @param nextToken
         *        A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the
         *        position in the list of predictive inbox placement tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number
         * of results is larger than the number you specified in this parameter, then the response includes a
         * <code>NextToken</code> element, which you can use to obtain additional results.
         * </p>
         * <p>
         * The value you specify has to be at least 0, and can be no more than 1000.
         * </p>
         * 
         * @param pageSize
         *        The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the
         *        number of results is larger than the number you specified in this parameter, then the response
         *        includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
         *        <p>
         *        The value you specify has to be at least 0, and can be no more than 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliverabilityTestReportsRequest model) {
            super(model);
            nextToken(model.nextToken);
            pageSize(model.pageSize);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeliverabilityTestReportsRequest build() {
            return new ListDeliverabilityTestReportsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
