/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the event destination. Specifically, it defines which services receive events from emails sent
 * using the configuration set that the event destination is associated with. Also defines the types of events that are
 * sent to the event destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventDestinationDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<EventDestinationDefinition.Builder, EventDestinationDefinition> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EventDestinationDefinition::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<List<String>> MATCHING_EVENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventDestinationDefinition::matchingEventTypesAsStrings))
            .setter(setter(Builder::matchingEventTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchingEventTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KinesisFirehoseDestination> KINESIS_FIREHOSE_DESTINATION_FIELD = SdkField
            .<KinesisFirehoseDestination> builder(MarshallingType.SDK_POJO)
            .getter(getter(EventDestinationDefinition::kinesisFirehoseDestination))
            .setter(setter(Builder::kinesisFirehoseDestination))
            .constructor(KinesisFirehoseDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseDestination").build())
            .build();

    private static final SdkField<CloudWatchDestination> CLOUD_WATCH_DESTINATION_FIELD = SdkField
            .<CloudWatchDestination> builder(MarshallingType.SDK_POJO)
            .getter(getter(EventDestinationDefinition::cloudWatchDestination)).setter(setter(Builder::cloudWatchDestination))
            .constructor(CloudWatchDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchDestination").build())
            .build();

    private static final SdkField<SnsDestination> SNS_DESTINATION_FIELD = SdkField
            .<SnsDestination> builder(MarshallingType.SDK_POJO).getter(getter(EventDestinationDefinition::snsDestination))
            .setter(setter(Builder::snsDestination)).constructor(SnsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsDestination").build()).build();

    private static final SdkField<PinpointDestination> PINPOINT_DESTINATION_FIELD = SdkField
            .<PinpointDestination> builder(MarshallingType.SDK_POJO)
            .getter(getter(EventDestinationDefinition::pinpointDestination)).setter(setter(Builder::pinpointDestination))
            .constructor(PinpointDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinpointDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            MATCHING_EVENT_TYPES_FIELD, KINESIS_FIREHOSE_DESTINATION_FIELD, CLOUD_WATCH_DESTINATION_FIELD, SNS_DESTINATION_FIELD,
            PINPOINT_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final List<String> matchingEventTypes;

    private final KinesisFirehoseDestination kinesisFirehoseDestination;

    private final CloudWatchDestination cloudWatchDestination;

    private final SnsDestination snsDestination;

    private final PinpointDestination pinpointDestination;

    private EventDestinationDefinition(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.matchingEventTypes = builder.matchingEventTypes;
        this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
        this.cloudWatchDestination = builder.cloudWatchDestination;
        this.snsDestination = builder.snsDestination;
        this.pinpointDestination = builder.pinpointDestination;
    }

    /**
     * <p>
     * If <code>true</code>, the event destination is enabled. When the event destination is enabled, the specified
     * event types are sent to the destinations in this <code>EventDestinationDefinition</code>.
     * </p>
     * <p>
     * If <code>false</code>, the event destination is disabled. When the event destination is disabled, events aren't
     * sent to the specified destinations.
     * </p>
     * 
     * @return If <code>true</code>, the event destination is enabled. When the event destination is enabled, the
     *         specified event types are sent to the destinations in this <code>EventDestinationDefinition</code>.</p>
     *         <p>
     *         If <code>false</code>, the event destination is disabled. When the event destination is disabled, events
     *         aren't sent to the specified destinations.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * An array that specifies which events Amazon Pinpoint should send to the destinations in this
     * <code>EventDestinationDefinition</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchingEventTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that specifies which events Amazon Pinpoint should send to the destinations in this
     *         <code>EventDestinationDefinition</code>.
     */
    public List<EventType> matchingEventTypes() {
        return EventTypesCopier.copyStringToEnum(matchingEventTypes);
    }

    /**
     * Returns true if the MatchingEventTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMatchingEventTypes() {
        return matchingEventTypes != null && !(matchingEventTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that specifies which events Amazon Pinpoint should send to the destinations in this
     * <code>EventDestinationDefinition</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchingEventTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that specifies which events Amazon Pinpoint should send to the destinations in this
     *         <code>EventDestinationDefinition</code>.
     */
    public List<String> matchingEventTypesAsStrings() {
        return matchingEventTypes;
    }

    /**
     * <p>
     * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis
     * Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
     * </p>
     * 
     * @return An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon
     *         Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
     */
    public KinesisFirehoseDestination kinesisFirehoseDestination() {
        return kinesisFirehoseDestination;
    }

    /**
     * <p>
     * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
     * monitor and gain insights on your email sending metrics.
     * </p>
     * 
     * @return An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch
     *         to monitor and gain insights on your email sending metrics.
     */
    public CloudWatchDestination cloudWatchDestination() {
        return cloudWatchDestination;
    }

    /**
     * <p>
     * An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification
     * when certain email events occur.
     * </p>
     * 
     * @return An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send
     *         notification when certain email events occur.
     */
    public SnsDestination snsDestination() {
        return snsDestination;
    }

    /**
     * <p>
     * An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint events to
     * create attributes in Amazon Pinpoint projects. You can use these attributes to create segments for your
     * campaigns.
     * </p>
     * 
     * @return An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint events
     *         to create attributes in Amazon Pinpoint projects. You can use these attributes to create segments for
     *         your campaigns.
     */
    public PinpointDestination pinpointDestination() {
        return pinpointDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(matchingEventTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseDestination());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchDestination());
        hashCode = 31 * hashCode + Objects.hashCode(snsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(pinpointDestination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDestinationDefinition)) {
            return false;
        }
        EventDestinationDefinition other = (EventDestinationDefinition) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(matchingEventTypesAsStrings(), other.matchingEventTypesAsStrings())
                && Objects.equals(kinesisFirehoseDestination(), other.kinesisFirehoseDestination())
                && Objects.equals(cloudWatchDestination(), other.cloudWatchDestination())
                && Objects.equals(snsDestination(), other.snsDestination())
                && Objects.equals(pinpointDestination(), other.pinpointDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventDestinationDefinition").add("Enabled", enabled())
                .add("MatchingEventTypes", matchingEventTypesAsStrings())
                .add("KinesisFirehoseDestination", kinesisFirehoseDestination())
                .add("CloudWatchDestination", cloudWatchDestination()).add("SnsDestination", snsDestination())
                .add("PinpointDestination", pinpointDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "MatchingEventTypes":
            return Optional.ofNullable(clazz.cast(matchingEventTypesAsStrings()));
        case "KinesisFirehoseDestination":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseDestination()));
        case "CloudWatchDestination":
            return Optional.ofNullable(clazz.cast(cloudWatchDestination()));
        case "SnsDestination":
            return Optional.ofNullable(clazz.cast(snsDestination()));
        case "PinpointDestination":
            return Optional.ofNullable(clazz.cast(pinpointDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventDestinationDefinition, T> g) {
        return obj -> g.apply((EventDestinationDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventDestinationDefinition> {
        /**
         * <p>
         * If <code>true</code>, the event destination is enabled. When the event destination is enabled, the specified
         * event types are sent to the destinations in this <code>EventDestinationDefinition</code>.
         * </p>
         * <p>
         * If <code>false</code>, the event destination is disabled. When the event destination is disabled, events
         * aren't sent to the specified destinations.
         * </p>
         * 
         * @param enabled
         *        If <code>true</code>, the event destination is enabled. When the event destination is enabled, the
         *        specified event types are sent to the destinations in this <code>EventDestinationDefinition</code>
         *        .</p>
         *        <p>
         *        If <code>false</code>, the event destination is disabled. When the event destination is disabled,
         *        events aren't sent to the specified destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * An array that specifies which events Amazon Pinpoint should send to the destinations in this
         * <code>EventDestinationDefinition</code>.
         * </p>
         * 
         * @param matchingEventTypes
         *        An array that specifies which events Amazon Pinpoint should send to the destinations in this
         *        <code>EventDestinationDefinition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes);

        /**
         * <p>
         * An array that specifies which events Amazon Pinpoint should send to the destinations in this
         * <code>EventDestinationDefinition</code>.
         * </p>
         * 
         * @param matchingEventTypes
         *        An array that specifies which events Amazon Pinpoint should send to the destinations in this
         *        <code>EventDestinationDefinition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypesWithStrings(String... matchingEventTypes);

        /**
         * <p>
         * An array that specifies which events Amazon Pinpoint should send to the destinations in this
         * <code>EventDestinationDefinition</code>.
         * </p>
         * 
         * @param matchingEventTypes
         *        An array that specifies which events Amazon Pinpoint should send to the destinations in this
         *        <code>EventDestinationDefinition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypes(Collection<EventType> matchingEventTypes);

        /**
         * <p>
         * An array that specifies which events Amazon Pinpoint should send to the destinations in this
         * <code>EventDestinationDefinition</code>.
         * </p>
         * 
         * @param matchingEventTypes
         *        An array that specifies which events Amazon Pinpoint should send to the destinations in this
         *        <code>EventDestinationDefinition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypes(EventType... matchingEventTypes);

        /**
         * <p>
         * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon
         * Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
         * </p>
         * 
         * @param kinesisFirehoseDestination
         *        An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use
         *        Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination);

        /**
         * <p>
         * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon
         * Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisFirehoseDestination.Builder} avoiding the
         * need to create one manually via {@link KinesisFirehoseDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisFirehoseDestination(KinesisFirehoseDestination)}.
         * 
         * @param kinesisFirehoseDestination
         *        a consumer that will call methods on {@link KinesisFirehoseDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseDestination(KinesisFirehoseDestination)
         */
        default Builder kinesisFirehoseDestination(Consumer<KinesisFirehoseDestination.Builder> kinesisFirehoseDestination) {
            return kinesisFirehoseDestination(KinesisFirehoseDestination.builder().applyMutation(kinesisFirehoseDestination)
                    .build());
        }

        /**
         * <p>
         * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
         * monitor and gain insights on your email sending metrics.
         * </p>
         * 
         * @param cloudWatchDestination
         *        An object that defines an Amazon CloudWatch destination for email events. You can use Amazon
         *        CloudWatch to monitor and gain insights on your email sending metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchDestination(CloudWatchDestination cloudWatchDestination);

        /**
         * <p>
         * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
         * monitor and gain insights on your email sending metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchDestination.Builder} avoiding the need
         * to create one manually via {@link CloudWatchDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudWatchDestination(CloudWatchDestination)}.
         * 
         * @param cloudWatchDestination
         *        a consumer that will call methods on {@link CloudWatchDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchDestination(CloudWatchDestination)
         */
        default Builder cloudWatchDestination(Consumer<CloudWatchDestination.Builder> cloudWatchDestination) {
            return cloudWatchDestination(CloudWatchDestination.builder().applyMutation(cloudWatchDestination).build());
        }

        /**
         * <p>
         * An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send
         * notification when certain email events occur.
         * </p>
         * 
         * @param snsDestination
         *        An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send
         *        notification when certain email events occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsDestination(SnsDestination snsDestination);

        /**
         * <p>
         * An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send
         * notification when certain email events occur.
         * </p>
         * This is a convenience that creates an instance of the {@link SnsDestination.Builder} avoiding the need to
         * create one manually via {@link SnsDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnsDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #snsDestination(SnsDestination)}.
         * 
         * @param snsDestination
         *        a consumer that will call methods on {@link SnsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snsDestination(SnsDestination)
         */
        default Builder snsDestination(Consumer<SnsDestination.Builder> snsDestination) {
            return snsDestination(SnsDestination.builder().applyMutation(snsDestination).build());
        }

        /**
         * <p>
         * An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint events to
         * create attributes in Amazon Pinpoint projects. You can use these attributes to create segments for your
         * campaigns.
         * </p>
         * 
         * @param pinpointDestination
         *        An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint
         *        events to create attributes in Amazon Pinpoint projects. You can use these attributes to create
         *        segments for your campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinpointDestination(PinpointDestination pinpointDestination);

        /**
         * <p>
         * An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint events to
         * create attributes in Amazon Pinpoint projects. You can use these attributes to create segments for your
         * campaigns.
         * </p>
         * This is a convenience that creates an instance of the {@link PinpointDestination.Builder} avoiding the need
         * to create one manually via {@link PinpointDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link PinpointDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #pinpointDestination(PinpointDestination)}.
         * 
         * @param pinpointDestination
         *        a consumer that will call methods on {@link PinpointDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pinpointDestination(PinpointDestination)
         */
        default Builder pinpointDestination(Consumer<PinpointDestination.Builder> pinpointDestination) {
            return pinpointDestination(PinpointDestination.builder().applyMutation(pinpointDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private List<String> matchingEventTypes = DefaultSdkAutoConstructList.getInstance();

        private KinesisFirehoseDestination kinesisFirehoseDestination;

        private CloudWatchDestination cloudWatchDestination;

        private SnsDestination snsDestination;

        private PinpointDestination pinpointDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDestinationDefinition model) {
            enabled(model.enabled);
            matchingEventTypesWithStrings(model.matchingEventTypes);
            kinesisFirehoseDestination(model.kinesisFirehoseDestination);
            cloudWatchDestination(model.cloudWatchDestination);
            snsDestination(model.snsDestination);
            pinpointDestination(model.pinpointDestination);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<String> getMatchingEventTypes() {
            return matchingEventTypes;
        }

        @Override
        public final Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypesWithStrings(String... matchingEventTypes) {
            matchingEventTypesWithStrings(Arrays.asList(matchingEventTypes));
            return this;
        }

        @Override
        public final Builder matchingEventTypes(Collection<EventType> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copyEnumToString(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypes(EventType... matchingEventTypes) {
            matchingEventTypes(Arrays.asList(matchingEventTypes));
            return this;
        }

        public final void setMatchingEventTypes(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
        }

        public final KinesisFirehoseDestination.Builder getKinesisFirehoseDestination() {
            return kinesisFirehoseDestination != null ? kinesisFirehoseDestination.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination;
            return this;
        }

        public final void setKinesisFirehoseDestination(KinesisFirehoseDestination.BuilderImpl kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination != null ? kinesisFirehoseDestination.build() : null;
        }

        public final CloudWatchDestination.Builder getCloudWatchDestination() {
            return cloudWatchDestination != null ? cloudWatchDestination.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchDestination(CloudWatchDestination cloudWatchDestination) {
            this.cloudWatchDestination = cloudWatchDestination;
            return this;
        }

        public final void setCloudWatchDestination(CloudWatchDestination.BuilderImpl cloudWatchDestination) {
            this.cloudWatchDestination = cloudWatchDestination != null ? cloudWatchDestination.build() : null;
        }

        public final SnsDestination.Builder getSnsDestination() {
            return snsDestination != null ? snsDestination.toBuilder() : null;
        }

        @Override
        public final Builder snsDestination(SnsDestination snsDestination) {
            this.snsDestination = snsDestination;
            return this;
        }

        public final void setSnsDestination(SnsDestination.BuilderImpl snsDestination) {
            this.snsDestination = snsDestination != null ? snsDestination.build() : null;
        }

        public final PinpointDestination.Builder getPinpointDestination() {
            return pinpointDestination != null ? pinpointDestination.toBuilder() : null;
        }

        @Override
        public final Builder pinpointDestination(PinpointDestination pinpointDestination) {
            this.pinpointDestination = pinpointDestination;
            return this;
        }

        public final void setPinpointDestination(PinpointDestination.BuilderImpl pinpointDestination) {
            this.pinpointDestination = pinpointDestination != null ? pinpointDestination.build() : null;
        }

        @Override
        public EventDestinationDefinition build() {
            return new EventDestinationDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
