/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.CloudWatchDimensionConfiguration;
import software.amazon.awssdk.services.pinpointemail.model.CloudWatchDimensionConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchDestination> {
    private static final SdkField<List<CloudWatchDimensionConfiguration>> DIMENSION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CloudWatchDestination.getter(CloudWatchDestination::dimensionConfigurations)).setter(CloudWatchDestination.setter(Builder::dimensionConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchDimensionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CloudWatchDimensionConfiguration> dimensionConfigurations;

    private CloudWatchDestination(BuilderImpl builder) {
        this.dimensionConfigurations = builder.dimensionConfigurations;
    }

    public boolean hasDimensionConfigurations() {
        return this.dimensionConfigurations != null && !(this.dimensionConfigurations instanceof SdkAutoConstructList);
    }

    public List<CloudWatchDimensionConfiguration> dimensionConfigurations() {
        return this.dimensionConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDestination)) {
            return false;
        }
        CloudWatchDestination other = (CloudWatchDestination)obj;
        return Objects.equals(this.dimensionConfigurations(), other.dimensionConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchDestination").add("DimensionConfigurations", this.dimensionConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionConfigurations": {
                return Optional.ofNullable(clazz.cast(this.dimensionConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchDestination, T> g) {
        return obj -> g.apply((CloudWatchDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CloudWatchDimensionConfiguration> dimensionConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchDestination model) {
            this.dimensionConfigurations(model.dimensionConfigurations);
        }

        public final Collection<CloudWatchDimensionConfiguration.Builder> getDimensionConfigurations() {
            return this.dimensionConfigurations != null ? (Collection)this.dimensionConfigurations.stream().map(CloudWatchDimensionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copy(dimensionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(CloudWatchDimensionConfiguration ... dimensionConfigurations) {
            this.dimensionConfigurations(Arrays.asList(dimensionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(Consumer<CloudWatchDimensionConfiguration.Builder> ... dimensionConfigurations) {
            this.dimensionConfigurations(Stream.of(dimensionConfigurations).map(c -> (CloudWatchDimensionConfiguration)((CloudWatchDimensionConfiguration.Builder)CloudWatchDimensionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensionConfigurations(Collection<CloudWatchDimensionConfiguration.BuilderImpl> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copyFromBuilder(dimensionConfigurations);
        }

        public CloudWatchDestination build() {
            return new CloudWatchDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchDestination> {
        public Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> var1);

        public Builder dimensionConfigurations(CloudWatchDimensionConfiguration ... var1);

        public Builder dimensionConfigurations(Consumer<CloudWatchDimensionConfiguration.Builder> ... var1);
    }
}

