/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to set the attributes that control how bounce and complaint events are processed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEmailIdentityFeedbackAttributesRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<PutEmailIdentityFeedbackAttributesRequest.Builder, PutEmailIdentityFeedbackAttributesRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEmailIdentityFeedbackAttributesRequest::emailIdentity)).setter(setter(Builder::emailIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailIdentity").build()).build();

    private static final SdkField<Boolean> EMAIL_FORWARDING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutEmailIdentityFeedbackAttributesRequest::emailForwardingEnabled))
            .setter(setter(Builder::emailForwardingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailForwardingEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD,
            EMAIL_FORWARDING_ENABLED_FIELD));

    private final String emailIdentity;

    private final Boolean emailForwardingEnabled;

    private PutEmailIdentityFeedbackAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
        this.emailForwardingEnabled = builder.emailForwardingEnabled;
    }

    /**
     * <p>
     * The email identity that you want to configure bounce and complaint feedback forwarding for.
     * </p>
     * 
     * @return The email identity that you want to configure bounce and complaint feedback forwarding for.
     */
    public String emailIdentity() {
        return emailIdentity;
    }

    /**
     * <p>
     * Sets the feedback forwarding configuration for the identity.
     * </p>
     * <p>
     * If the value is <code>true</code>, Amazon Pinpoint sends you email notifications when bounce or complaint events
     * occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the
     * original email.
     * </p>
     * <p>
     * When you set this value to <code>false</code>, Amazon Pinpoint sends notifications through other mechanisms, such
     * as by notifying an Amazon SNS topic or another event destination. You're required to have a method of tracking
     * bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications,
     * Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
     * </p>
     * 
     * @return Sets the feedback forwarding configuration for the identity.</p>
     *         <p>
     *         If the value is <code>true</code>, Amazon Pinpoint sends you email notifications when bounce or complaint
     *         events occur. Amazon Pinpoint sends this notification to the address that you specified in the
     *         Return-Path header of the original email.
     *         </p>
     *         <p>
     *         When you set this value to <code>false</code>, Amazon Pinpoint sends notifications through other
     *         mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to
     *         have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving
     *         bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur
     *         (even if this setting is disabled).
     */
    public Boolean emailForwardingEnabled() {
        return emailForwardingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(emailForwardingEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEmailIdentityFeedbackAttributesRequest)) {
            return false;
        }
        PutEmailIdentityFeedbackAttributesRequest other = (PutEmailIdentityFeedbackAttributesRequest) obj;
        return Objects.equals(emailIdentity(), other.emailIdentity())
                && Objects.equals(emailForwardingEnabled(), other.emailForwardingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutEmailIdentityFeedbackAttributesRequest").add("EmailIdentity", emailIdentity())
                .add("EmailForwardingEnabled", emailForwardingEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailIdentity":
            return Optional.ofNullable(clazz.cast(emailIdentity()));
        case "EmailForwardingEnabled":
            return Optional.ofNullable(clazz.cast(emailForwardingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEmailIdentityFeedbackAttributesRequest, T> g) {
        return obj -> g.apply((PutEmailIdentityFeedbackAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutEmailIdentityFeedbackAttributesRequest> {
        /**
         * <p>
         * The email identity that you want to configure bounce and complaint feedback forwarding for.
         * </p>
         * 
         * @param emailIdentity
         *        The email identity that you want to configure bounce and complaint feedback forwarding for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailIdentity(String emailIdentity);

        /**
         * <p>
         * Sets the feedback forwarding configuration for the identity.
         * </p>
         * <p>
         * If the value is <code>true</code>, Amazon Pinpoint sends you email notifications when bounce or complaint
         * events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path
         * header of the original email.
         * </p>
         * <p>
         * When you set this value to <code>false</code>, Amazon Pinpoint sends notifications through other mechanisms,
         * such as by notifying an Amazon SNS topic or another event destination. You're required to have a method of
         * tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint
         * notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is
         * disabled).
         * </p>
         * 
         * @param emailForwardingEnabled
         *        Sets the feedback forwarding configuration for the identity.</p>
         *        <p>
         *        If the value is <code>true</code>, Amazon Pinpoint sends you email notifications when bounce or
         *        complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in
         *        the Return-Path header of the original email.
         *        </p>
         *        <p>
         *        When you set this value to <code>false</code>, Amazon Pinpoint sends notifications through other
         *        mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to
         *        have a method of tracking bounces and complaints. If you haven't set up another mechanism for
         *        receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these
         *        events occur (even if this setting is disabled).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailForwardingEnabled(Boolean emailForwardingEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private String emailIdentity;

        private Boolean emailForwardingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEmailIdentityFeedbackAttributesRequest model) {
            super(model);
            emailIdentity(model.emailIdentity);
            emailForwardingEnabled(model.emailForwardingEnabled);
        }

        public final String getEmailIdentity() {
            return emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        public final Boolean getEmailForwardingEnabled() {
            return emailForwardingEnabled;
        }

        @Override
        public final Builder emailForwardingEnabled(Boolean emailForwardingEnabled) {
            this.emailForwardingEnabled = emailForwardingEnabled;
            return this;
        }

        public final void setEmailForwardingEnabled(Boolean emailForwardingEnabled) {
            this.emailForwardingEnabled = emailForwardingEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEmailIdentityFeedbackAttributesRequest build() {
            return new PutEmailIdentityFeedbackAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
