/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the name and value of a tag that you apply to an email. You can use message tags when you publish email
 * sending events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageTag implements SdkPojo, Serializable, ToCopyableBuilder<MessageTag.Builder, MessageTag> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MessageTag::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MessageTag::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private MessageTag(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the message tag. The message tag name has to meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * It can contain no more than 256 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the message tag. The message tag name has to meet the following criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can contain no more than 256 characters.
     *         </p>
     *         </li>
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value of the message tag. The message tag value has to meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * It can contain no more than 256 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The value of the message tag. The message tag value has to meet the following criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can contain no more than 256 characters.
     *         </p>
     *         </li>
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTag)) {
            return false;
        }
        MessageTag other = (MessageTag) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MessageTag").add("Name", name()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageTag, T> g) {
        return obj -> g.apply((MessageTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageTag> {
        /**
         * <p>
         * The name of the message tag. The message tag name has to meet the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * It can contain no more than 256 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the message tag. The message tag name has to meet the following criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can contain no more than 256 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the message tag. The message tag value has to meet the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * It can contain no more than 256 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param value
         *        The value of the message tag. The message tag value has to meet the following criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can contain no more than 256 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTag model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public MessageTag build() {
            return new MessageTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
