/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of all of the identities that you've attempted to verify for use with Amazon Pinpoint, regardless of whether
 * or not those identities were successfully verified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEmailIdentitiesResponse extends PinpointEmailResponse implements
        ToCopyableBuilder<ListEmailIdentitiesResponse.Builder, ListEmailIdentitiesResponse> {
    private static final SdkField<List<IdentityInfo>> EMAIL_IDENTITIES_FIELD = SdkField
            .<List<IdentityInfo>> builder(MarshallingType.LIST)
            .getter(getter(ListEmailIdentitiesResponse::emailIdentities))
            .setter(setter(Builder::emailIdentities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailIdentities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEmailIdentitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<IdentityInfo> emailIdentities;

    private final String nextToken;

    private ListEmailIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.emailIdentities = builder.emailIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EmailIdentities property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEmailIdentities() {
        return emailIdentities != null && !(emailIdentities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that includes all of the identities associated with your Amazon Pinpoint account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEmailIdentities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that includes all of the identities associated with your Amazon Pinpoint account.
     */
    public List<IdentityInfo> emailIdentities() {
        return emailIdentities;
    }

    /**
     * <p>
     * A token that indicates that there are additional configuration sets to list. To view additional configuration
     * sets, issue another request to <code>ListEmailIdentities</code>, and pass this token in the
     * <code>NextToken</code> parameter.
     * </p>
     * 
     * @return A token that indicates that there are additional configuration sets to list. To view additional
     *         configuration sets, issue another request to <code>ListEmailIdentities</code>, and pass this token in the
     *         <code>NextToken</code> parameter.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEmailIdentitiesResponse)) {
            return false;
        }
        ListEmailIdentitiesResponse other = (ListEmailIdentitiesResponse) obj;
        return Objects.equals(emailIdentities(), other.emailIdentities()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListEmailIdentitiesResponse").add("EmailIdentities", emailIdentities())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailIdentities":
            return Optional.ofNullable(clazz.cast(emailIdentities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEmailIdentitiesResponse, T> g) {
        return obj -> g.apply((ListEmailIdentitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEmailIdentitiesResponse> {
        /**
         * <p>
         * An array that includes all of the identities associated with your Amazon Pinpoint account.
         * </p>
         * 
         * @param emailIdentities
         *        An array that includes all of the identities associated with your Amazon Pinpoint account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailIdentities(Collection<IdentityInfo> emailIdentities);

        /**
         * <p>
         * An array that includes all of the identities associated with your Amazon Pinpoint account.
         * </p>
         * 
         * @param emailIdentities
         *        An array that includes all of the identities associated with your Amazon Pinpoint account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailIdentities(IdentityInfo... emailIdentities);

        /**
         * <p>
         * An array that includes all of the identities associated with your Amazon Pinpoint account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IdentityInfo>.Builder} avoiding the need to
         * create one manually via {@link List<IdentityInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IdentityInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #emailIdentities(List<IdentityInfo>)}.
         * 
         * @param emailIdentities
         *        a consumer that will call methods on {@link List<IdentityInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailIdentities(List<IdentityInfo>)
         */
        Builder emailIdentities(Consumer<IdentityInfo.Builder>... emailIdentities);

        /**
         * <p>
         * A token that indicates that there are additional configuration sets to list. To view additional configuration
         * sets, issue another request to <code>ListEmailIdentities</code>, and pass this token in the
         * <code>NextToken</code> parameter.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there are additional configuration sets to list. To view additional
         *        configuration sets, issue another request to <code>ListEmailIdentities</code>, and pass this token in
         *        the <code>NextToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointEmailResponse.BuilderImpl implements Builder {
        private List<IdentityInfo> emailIdentities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEmailIdentitiesResponse model) {
            super(model);
            emailIdentities(model.emailIdentities);
            nextToken(model.nextToken);
        }

        public final Collection<IdentityInfo.Builder> getEmailIdentities() {
            return emailIdentities != null ? emailIdentities.stream().map(IdentityInfo::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder emailIdentities(Collection<IdentityInfo> emailIdentities) {
            this.emailIdentities = IdentityInfoListCopier.copy(emailIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailIdentities(IdentityInfo... emailIdentities) {
            emailIdentities(Arrays.asList(emailIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailIdentities(Consumer<IdentityInfo.Builder>... emailIdentities) {
            emailIdentities(Stream.of(emailIdentities).map(c -> IdentityInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEmailIdentities(Collection<IdentityInfo.BuilderImpl> emailIdentities) {
            this.emailIdentities = IdentityInfoListCopier.copyFromBuilder(emailIdentities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEmailIdentitiesResponse build() {
            return new ListEmailIdentitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
