/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.EventDestination;
import software.amazon.awssdk.services.pinpointemail.model.EventDestinationsCopier;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigurationSetEventDestinationsResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, GetConfigurationSetEventDestinationsResponse> {
    private static final SdkField<List<EventDestination>> EVENT_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetConfigurationSetEventDestinationsResponse.getter(GetConfigurationSetEventDestinationsResponse::eventDestinations)).setter(GetConfigurationSetEventDestinationsResponse.setter(Builder::eventDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DESTINATIONS_FIELD));
    private final List<EventDestination> eventDestinations;

    private GetConfigurationSetEventDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.eventDestinations = builder.eventDestinations;
    }

    public List<EventDestination> eventDestinations() {
        return this.eventDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDestinations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationSetEventDestinationsResponse)) {
            return false;
        }
        GetConfigurationSetEventDestinationsResponse other = (GetConfigurationSetEventDestinationsResponse)((Object)obj);
        return Objects.equals(this.eventDestinations(), other.eventDestinations());
    }

    public String toString() {
        return ToString.builder((String)"GetConfigurationSetEventDestinationsResponse").add("EventDestinations", this.eventDestinations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDestinations": {
                return Optional.ofNullable(clazz.cast(this.eventDestinations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationSetEventDestinationsResponse, T> g) {
        return obj -> g.apply((GetConfigurationSetEventDestinationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private List<EventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationSetEventDestinationsResponse model) {
            super(model);
            this.eventDestinations(model.eventDestinations);
        }

        public final Collection<EventDestination.Builder> getEventDestinations() {
            return this.eventDestinations != null ? (Collection)this.eventDestinations.stream().map(EventDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(EventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<EventDestination.Builder> ... eventDestinations) {
            this.eventDestinations(Stream.of(eventDestinations).map(c -> (EventDestination)((EventDestination.Builder)EventDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventDestinations(Collection<EventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public GetConfigurationSetEventDestinationsResponse build() {
            return new GetConfigurationSetEventDestinationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigurationSetEventDestinationsResponse> {
        public Builder eventDestinations(Collection<EventDestination> var1);

        public Builder eventDestinations(EventDestination ... var1);

        public Builder eventDestinations(Consumer<EventDestination.Builder> ... var1);
    }
}

