/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteTreatmentResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WriteTreatmentResource> {
    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WriteTreatmentResource.getter(WriteTreatmentResource::messageConfiguration)).setter(WriteTreatmentResource.setter(Builder::messageConfiguration)).constructor(MessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WriteTreatmentResource.getter(WriteTreatmentResource::schedule)).setter(WriteTreatmentResource.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<Integer> SIZE_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(WriteTreatmentResource.getter(WriteTreatmentResource::sizePercent)).setter(WriteTreatmentResource.setter(Builder::sizePercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizePercent").build()}).build();
    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WriteTreatmentResource.getter(WriteTreatmentResource::treatmentDescription)).setter(WriteTreatmentResource.setter(Builder::treatmentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build()}).build();
    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WriteTreatmentResource.getter(WriteTreatmentResource::treatmentName)).setter(WriteTreatmentResource.setter(Builder::treatmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_CONFIGURATION_FIELD, SCHEDULE_FIELD, SIZE_PERCENT_FIELD, TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final MessageConfiguration messageConfiguration;
    private final Schedule schedule;
    private final Integer sizePercent;
    private final String treatmentDescription;
    private final String treatmentName;

    private WriteTreatmentResource(BuilderImpl builder) {
        this.messageConfiguration = builder.messageConfiguration;
        this.schedule = builder.schedule;
        this.sizePercent = builder.sizePercent;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    public MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public Integer sizePercent() {
        return this.sizePercent;
    }

    public String treatmentDescription() {
        return this.treatmentDescription;
    }

    public String treatmentName() {
        return this.treatmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizePercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteTreatmentResource)) {
            return false;
        }
        WriteTreatmentResource other = (WriteTreatmentResource)obj;
        return Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.sizePercent(), other.sizePercent()) && Objects.equals(this.treatmentDescription(), other.treatmentDescription()) && Objects.equals(this.treatmentName(), other.treatmentName());
    }

    public String toString() {
        return ToString.builder((String)"WriteTreatmentResource").add("MessageConfiguration", (Object)this.messageConfiguration()).add("Schedule", (Object)this.schedule()).add("SizePercent", (Object)this.sizePercent()).add("TreatmentDescription", (Object)this.treatmentDescription()).add("TreatmentName", (Object)this.treatmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.messageConfiguration()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "SizePercent": {
                return Optional.ofNullable(clazz.cast(this.sizePercent()));
            }
            case "TreatmentDescription": {
                return Optional.ofNullable(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.ofNullable(clazz.cast(this.treatmentName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteTreatmentResource, T> g) {
        return obj -> g.apply((WriteTreatmentResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MessageConfiguration messageConfiguration;
        private Schedule schedule;
        private Integer sizePercent;
        private String treatmentDescription;
        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteTreatmentResource model) {
            this.messageConfiguration(model.messageConfiguration);
            this.schedule(model.schedule);
            this.sizePercent(model.sizePercent);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final Integer getSizePercent() {
            return this.sizePercent;
        }

        @Override
        public final Builder sizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
            return this;
        }

        public final void setSizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public WriteTreatmentResource build() {
            return new WriteTreatmentResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WriteTreatmentResource> {
        public Builder messageConfiguration(MessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((MessageConfiguration)((MessageConfiguration.Builder)MessageConfiguration.builder().applyMutation(messageConfiguration)).build());
        }

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder sizePercent(Integer var1);

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);
    }
}

