/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration;
import software.amazon.awssdk.services.pinpoint.model.MapOfEndpointSendConfigurationCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendUsersMessageRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SendUsersMessageRequest> {
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SendUsersMessageRequest.getter(SendUsersMessageRequest::context)).setter(SendUsersMessageRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DirectMessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SendUsersMessageRequest.getter(SendUsersMessageRequest::messageConfiguration)).setter(SendUsersMessageRequest.setter(Builder::messageConfiguration)).constructor(DirectMessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendUsersMessageRequest.getter(SendUsersMessageRequest::traceId)).setter(SendUsersMessageRequest.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceId").build()}).build();
    private static final SdkField<Map<String, EndpointSendConfiguration>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SendUsersMessageRequest.getter(SendUsersMessageRequest::users)).setter(SendUsersMessageRequest.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointSendConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_FIELD, MESSAGE_CONFIGURATION_FIELD, TRACE_ID_FIELD, USERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> context;
    private final DirectMessageConfiguration messageConfiguration;
    private final String traceId;
    private final Map<String, EndpointSendConfiguration> users;

    private SendUsersMessageRequest(BuilderImpl builder) {
        this.context = builder.context;
        this.messageConfiguration = builder.messageConfiguration;
        this.traceId = builder.traceId;
        this.users = builder.users;
    }

    public Map<String, String> context() {
        return this.context;
    }

    public DirectMessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public String traceId() {
        return this.traceId;
    }

    public Map<String, EndpointSendConfiguration> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessageRequest)) {
            return false;
        }
        SendUsersMessageRequest other = (SendUsersMessageRequest)obj;
        return Objects.equals(this.context(), other.context()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.users(), other.users());
    }

    public String toString() {
        return ToString.builder((String)"SendUsersMessageRequest").add("Context", this.context()).add("MessageConfiguration", (Object)this.messageConfiguration()).add("TraceId", (Object)this.traceId()).add("Users", this.users()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "MessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.messageConfiguration()));
            }
            case "TraceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendUsersMessageRequest, T> g) {
        return obj -> g.apply((SendUsersMessageRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private DirectMessageConfiguration messageConfiguration;
        private String traceId;
        private Map<String, EndpointSendConfiguration> users = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessageRequest model) {
            this.context(model.context);
            this.messageConfiguration(model.messageConfiguration);
            this.traceId(model.traceId);
            this.users(model.users);
        }

        public final Map<String, String> getContext() {
            return this.context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final DirectMessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(DirectMessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(DirectMessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public final Map<String, EndpointSendConfiguration.Builder> getUsers() {
            return this.users != null ? CollectionUtils.mapValues(this.users, EndpointSendConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder users(Map<String, EndpointSendConfiguration> users) {
            this.users = MapOfEndpointSendConfigurationCopier.copy(users);
            return this;
        }

        public final void setUsers(Map<String, EndpointSendConfiguration.BuilderImpl> users) {
            this.users = MapOfEndpointSendConfigurationCopier.copyFromBuilder(users);
        }

        public SendUsersMessageRequest build() {
            return new SendUsersMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SendUsersMessageRequest> {
        public Builder context(Map<String, String> var1);

        public Builder messageConfiguration(DirectMessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<DirectMessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((DirectMessageConfiguration)((DirectMessageConfiguration.Builder)DirectMessageConfiguration.builder().applyMutation(messageConfiguration)).build());
        }

        public Builder traceId(String var1);

        public Builder users(Map<String, EndpointSendConfiguration> var1);
    }
}

