/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.MessageRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendMessagesRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, SendMessagesRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendMessagesRequest.getter(SendMessagesRequest::applicationId)).setter(SendMessagesRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<MessageRequest> MESSAGE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SendMessagesRequest.getter(SendMessagesRequest::messageRequest)).setter(SendMessagesRequest.setter(Builder::messageRequest)).constructor(MessageRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, MESSAGE_REQUEST_FIELD));
    private final String applicationId;
    private final MessageRequest messageRequest;

    private SendMessagesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.messageRequest = builder.messageRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public MessageRequest messageRequest() {
        return this.messageRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessagesRequest)) {
            return false;
        }
        SendMessagesRequest other = (SendMessagesRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.messageRequest(), other.messageRequest());
    }

    public String toString() {
        return ToString.builder((String)"SendMessagesRequest").add("ApplicationId", (Object)this.applicationId()).add("MessageRequest", (Object)this.messageRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "MessageRequest": {
                return Optional.ofNullable(clazz.cast(this.messageRequest()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendMessagesRequest, T> g) {
        return obj -> g.apply((SendMessagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private MessageRequest messageRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessagesRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.messageRequest(model.messageRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final MessageRequest.Builder getMessageRequest() {
            return this.messageRequest != null ? this.messageRequest.toBuilder() : null;
        }

        @Override
        public final Builder messageRequest(MessageRequest messageRequest) {
            this.messageRequest = messageRequest;
            return this;
        }

        public final void setMessageRequest(MessageRequest.BuilderImpl messageRequest) {
            this.messageRequest = messageRequest != null ? messageRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMessagesRequest build() {
            return new SendMessagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendMessagesRequest> {
        public Builder applicationId(String var1);

        public Builder messageRequest(MessageRequest var1);

        default public Builder messageRequest(Consumer<MessageRequest.Builder> messageRequest) {
            return this.messageRequest((MessageRequest)((MessageRequest.Builder)MessageRequest.builder().applyMutation(messageRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

