/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.InAppMessageBodyConfig;
import software.amazon.awssdk.services.pinpoint.model.InAppMessageButton;
import software.amazon.awssdk.services.pinpoint.model.InAppMessageHeaderConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InAppMessageContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InAppMessageContent> {
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackgroundColor").getter(InAppMessageContent.getter(InAppMessageContent::backgroundColor)).setter(InAppMessageContent.setter(Builder::backgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()}).build();
    private static final SdkField<InAppMessageBodyConfig> BODY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BodyConfig").getter(InAppMessageContent.getter(InAppMessageContent::bodyConfig)).setter(InAppMessageContent.setter(Builder::bodyConfig)).constructor(InAppMessageBodyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyConfig").build()}).build();
    private static final SdkField<InAppMessageHeaderConfig> HEADER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HeaderConfig").getter(InAppMessageContent.getter(InAppMessageContent::headerConfig)).setter(InAppMessageContent.setter(Builder::headerConfig)).constructor(InAppMessageHeaderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderConfig").build()}).build();
    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUrl").getter(InAppMessageContent.getter(InAppMessageContent::imageUrl)).setter(InAppMessageContent.setter(Builder::imageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()}).build();
    private static final SdkField<InAppMessageButton> PRIMARY_BTN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryBtn").getter(InAppMessageContent.getter(InAppMessageContent::primaryBtn)).setter(InAppMessageContent.setter(Builder::primaryBtn)).constructor(InAppMessageButton::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryBtn").build()}).build();
    private static final SdkField<InAppMessageButton> SECONDARY_BTN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondaryBtn").getter(InAppMessageContent.getter(InAppMessageContent::secondaryBtn)).setter(InAppMessageContent.setter(Builder::secondaryBtn)).constructor(InAppMessageButton::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryBtn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKGROUND_COLOR_FIELD, BODY_CONFIG_FIELD, HEADER_CONFIG_FIELD, IMAGE_URL_FIELD, PRIMARY_BTN_FIELD, SECONDARY_BTN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InAppMessageContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String backgroundColor;
    private final InAppMessageBodyConfig bodyConfig;
    private final InAppMessageHeaderConfig headerConfig;
    private final String imageUrl;
    private final InAppMessageButton primaryBtn;
    private final InAppMessageButton secondaryBtn;

    private InAppMessageContent(BuilderImpl builder) {
        this.backgroundColor = builder.backgroundColor;
        this.bodyConfig = builder.bodyConfig;
        this.headerConfig = builder.headerConfig;
        this.imageUrl = builder.imageUrl;
        this.primaryBtn = builder.primaryBtn;
        this.secondaryBtn = builder.secondaryBtn;
    }

    public final String backgroundColor() {
        return this.backgroundColor;
    }

    public final InAppMessageBodyConfig bodyConfig() {
        return this.bodyConfig;
    }

    public final InAppMessageHeaderConfig headerConfig() {
        return this.headerConfig;
    }

    public final String imageUrl() {
        return this.imageUrl;
    }

    public final InAppMessageButton primaryBtn() {
        return this.primaryBtn;
    }

    public final InAppMessageButton secondaryBtn() {
        return this.secondaryBtn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.bodyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.headerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryBtn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryBtn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessageContent)) {
            return false;
        }
        InAppMessageContent other = (InAppMessageContent)obj;
        return Objects.equals(this.backgroundColor(), other.backgroundColor()) && Objects.equals(this.bodyConfig(), other.bodyConfig()) && Objects.equals(this.headerConfig(), other.headerConfig()) && Objects.equals(this.imageUrl(), other.imageUrl()) && Objects.equals(this.primaryBtn(), other.primaryBtn()) && Objects.equals(this.secondaryBtn(), other.secondaryBtn());
    }

    public final String toString() {
        return ToString.builder((String)"InAppMessageContent").add("BackgroundColor", (Object)this.backgroundColor()).add("BodyConfig", (Object)this.bodyConfig()).add("HeaderConfig", (Object)this.headerConfig()).add("ImageUrl", (Object)this.imageUrl()).add("PrimaryBtn", (Object)this.primaryBtn()).add("SecondaryBtn", (Object)this.secondaryBtn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColor()));
            }
            case "BodyConfig": {
                return Optional.ofNullable(clazz.cast(this.bodyConfig()));
            }
            case "HeaderConfig": {
                return Optional.ofNullable(clazz.cast(this.headerConfig()));
            }
            case "ImageUrl": {
                return Optional.ofNullable(clazz.cast(this.imageUrl()));
            }
            case "PrimaryBtn": {
                return Optional.ofNullable(clazz.cast(this.primaryBtn()));
            }
            case "SecondaryBtn": {
                return Optional.ofNullable(clazz.cast(this.secondaryBtn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
        map.put("BodyConfig", BODY_CONFIG_FIELD);
        map.put("HeaderConfig", HEADER_CONFIG_FIELD);
        map.put("ImageUrl", IMAGE_URL_FIELD);
        map.put("PrimaryBtn", PRIMARY_BTN_FIELD);
        map.put("SecondaryBtn", SECONDARY_BTN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InAppMessageContent, T> g) {
        return obj -> g.apply((InAppMessageContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backgroundColor;
        private InAppMessageBodyConfig bodyConfig;
        private InAppMessageHeaderConfig headerConfig;
        private String imageUrl;
        private InAppMessageButton primaryBtn;
        private InAppMessageButton secondaryBtn;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessageContent model) {
            this.backgroundColor(model.backgroundColor);
            this.bodyConfig(model.bodyConfig);
            this.headerConfig(model.headerConfig);
            this.imageUrl(model.imageUrl);
            this.primaryBtn(model.primaryBtn);
            this.secondaryBtn(model.secondaryBtn);
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final InAppMessageBodyConfig.Builder getBodyConfig() {
            return this.bodyConfig != null ? this.bodyConfig.toBuilder() : null;
        }

        public final void setBodyConfig(InAppMessageBodyConfig.BuilderImpl bodyConfig) {
            this.bodyConfig = bodyConfig != null ? bodyConfig.build() : null;
        }

        @Override
        public final Builder bodyConfig(InAppMessageBodyConfig bodyConfig) {
            this.bodyConfig = bodyConfig;
            return this;
        }

        public final InAppMessageHeaderConfig.Builder getHeaderConfig() {
            return this.headerConfig != null ? this.headerConfig.toBuilder() : null;
        }

        public final void setHeaderConfig(InAppMessageHeaderConfig.BuilderImpl headerConfig) {
            this.headerConfig = headerConfig != null ? headerConfig.build() : null;
        }

        @Override
        public final Builder headerConfig(InAppMessageHeaderConfig headerConfig) {
            this.headerConfig = headerConfig;
            return this;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final InAppMessageButton.Builder getPrimaryBtn() {
            return this.primaryBtn != null ? this.primaryBtn.toBuilder() : null;
        }

        public final void setPrimaryBtn(InAppMessageButton.BuilderImpl primaryBtn) {
            this.primaryBtn = primaryBtn != null ? primaryBtn.build() : null;
        }

        @Override
        public final Builder primaryBtn(InAppMessageButton primaryBtn) {
            this.primaryBtn = primaryBtn;
            return this;
        }

        public final InAppMessageButton.Builder getSecondaryBtn() {
            return this.secondaryBtn != null ? this.secondaryBtn.toBuilder() : null;
        }

        public final void setSecondaryBtn(InAppMessageButton.BuilderImpl secondaryBtn) {
            this.secondaryBtn = secondaryBtn != null ? secondaryBtn.build() : null;
        }

        @Override
        public final Builder secondaryBtn(InAppMessageButton secondaryBtn) {
            this.secondaryBtn = secondaryBtn;
            return this;
        }

        public InAppMessageContent build() {
            return new InAppMessageContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InAppMessageContent> {
        public Builder backgroundColor(String var1);

        public Builder bodyConfig(InAppMessageBodyConfig var1);

        default public Builder bodyConfig(Consumer<InAppMessageBodyConfig.Builder> bodyConfig) {
            return this.bodyConfig((InAppMessageBodyConfig)((InAppMessageBodyConfig.Builder)InAppMessageBodyConfig.builder().applyMutation(bodyConfig)).build());
        }

        public Builder headerConfig(InAppMessageHeaderConfig var1);

        default public Builder headerConfig(Consumer<InAppMessageHeaderConfig.Builder> headerConfig) {
            return this.headerConfig((InAppMessageHeaderConfig)((InAppMessageHeaderConfig.Builder)InAppMessageHeaderConfig.builder().applyMutation(headerConfig)).build());
        }

        public Builder imageUrl(String var1);

        public Builder primaryBtn(InAppMessageButton var1);

        default public Builder primaryBtn(Consumer<InAppMessageButton.Builder> primaryBtn) {
            return this.primaryBtn((InAppMessageButton)((InAppMessageButton.Builder)InAppMessageButton.builder().applyMutation(primaryBtn)).build());
        }

        public Builder secondaryBtn(InAppMessageButton var1);

        default public Builder secondaryBtn(Consumer<InAppMessageButton.Builder> secondaryBtn) {
            return this.secondaryBtn((InAppMessageButton)((InAppMessageButton.Builder)InAppMessageButton.builder().applyMutation(secondaryBtn)).build());
        }
    }
}

