/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApnsChannelRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateApnsChannelRequest.Builder, UpdateApnsChannelRequest> {
    private static final SdkField<APNSChannelRequest> APNS_CHANNEL_REQUEST_FIELD = SdkField
            .<APNSChannelRequest> builder(MarshallingType.SDK_POJO)
            .memberName("APNSChannelRequest")
            .getter(getter(UpdateApnsChannelRequest::apnsChannelRequest))
            .setter(setter(Builder::apnsChannelRequest))
            .constructor(APNSChannelRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSChannelRequest").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(UpdateApnsChannelRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APNS_CHANNEL_REQUEST_FIELD,
            APPLICATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final APNSChannelRequest apnsChannelRequest;

    private final String applicationId;

    private UpdateApnsChannelRequest(BuilderImpl builder) {
        super(builder);
        this.apnsChannelRequest = builder.apnsChannelRequest;
        this.applicationId = builder.applicationId;
    }

    /**
     * Returns the value of the APNSChannelRequest property for this object.
     * 
     * @return The value of the APNSChannelRequest property for this object.
     */
    public final APNSChannelRequest apnsChannelRequest() {
        return apnsChannelRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public final String applicationId() {
        return applicationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apnsChannelRequest());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApnsChannelRequest)) {
            return false;
        }
        UpdateApnsChannelRequest other = (UpdateApnsChannelRequest) obj;
        return Objects.equals(apnsChannelRequest(), other.apnsChannelRequest())
                && Objects.equals(applicationId(), other.applicationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApnsChannelRequest").add("APNSChannelRequest", apnsChannelRequest())
                .add("ApplicationId", applicationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "APNSChannelRequest":
            return Optional.ofNullable(clazz.cast(apnsChannelRequest()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("APNSChannelRequest", APNS_CHANNEL_REQUEST_FIELD);
        map.put("application-id", APPLICATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApnsChannelRequest, T> g) {
        return obj -> g.apply((UpdateApnsChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApnsChannelRequest> {
        /**
         * Sets the value of the APNSChannelRequest property for this object.
         *
         * @param apnsChannelRequest
         *        The new value for the APNSChannelRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnsChannelRequest(APNSChannelRequest apnsChannelRequest);

        /**
         * Sets the value of the APNSChannelRequest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link APNSChannelRequest.Builder} avoiding the
         * need to create one manually via {@link APNSChannelRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link APNSChannelRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #apnsChannelRequest(APNSChannelRequest)}.
         * 
         * @param apnsChannelRequest
         *        a consumer that will call methods on {@link APNSChannelRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apnsChannelRequest(APNSChannelRequest)
         */
        default Builder apnsChannelRequest(Consumer<APNSChannelRequest.Builder> apnsChannelRequest) {
            return apnsChannelRequest(APNSChannelRequest.builder().applyMutation(apnsChannelRequest).build());
        }

        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private APNSChannelRequest apnsChannelRequest;

        private String applicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApnsChannelRequest model) {
            super(model);
            apnsChannelRequest(model.apnsChannelRequest);
            applicationId(model.applicationId);
        }

        public final APNSChannelRequest.Builder getApnsChannelRequest() {
            return apnsChannelRequest != null ? apnsChannelRequest.toBuilder() : null;
        }

        public final void setApnsChannelRequest(APNSChannelRequest.BuilderImpl apnsChannelRequest) {
            this.apnsChannelRequest = apnsChannelRequest != null ? apnsChannelRequest.build() : null;
        }

        @Override
        public final Builder apnsChannelRequest(APNSChannelRequest apnsChannelRequest) {
            this.apnsChannelRequest = apnsChannelRequest;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApnsChannelRequest build() {
            return new UpdateApnsChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
