/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access
 * Management (IAM) role to use when publishing those events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteEventStream implements SdkPojo, Serializable,
        ToCopyableBuilder<WriteEventStream.Builder, WriteEventStream> {
    private static final SdkField<String> DESTINATION_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationStreamArn").getter(getter(WriteEventStream::destinationStreamArn))
            .setter(setter(Builder::destinationStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStreamArn").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(WriteEventStream::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_STREAM_ARN_FIELD,
            ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationStreamArn;

    private final String roleArn;

    private WriteEventStream(BuilderImpl builder) {
        this.destinationStreamArn = builder.destinationStreamArn;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery stream
     * that you want to publish event data to.
     * </p>
     * <p>
     * For a Kinesis data stream, the ARN format is:
     * arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable>account
     * -id</replaceable>:stream/<replaceable>stream_name</replaceable>
     * </p>
     * <p>
     * For a Kinesis Data Firehose delivery stream, the ARN format is:
     * arn:aws:firehose:<replaceable>region</replaceable>
     * :<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery
     *         stream that you want to publish event data to.</p>
     *         <p>
     *         For a Kinesis data stream, the ARN format is:
     *         arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable
     *         >account-id</replaceable>:stream/<replaceable>stream_name</replaceable>
     *         </p>
     *         <p>
     *         For a Kinesis Data Firehose delivery stream, the ARN format is:
     *         arn:aws:firehose:<replaceable>region</replaceable
     *         >:<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable>
     */
    public final String destinationStreamArn() {
        return destinationStreamArn;
    }

    /**
     * <p>
     * The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data to the
     * stream in your AWS account.
     * </p>
     * 
     * @return The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data
     *         to the stream in your AWS account.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteEventStream)) {
            return false;
        }
        WriteEventStream other = (WriteEventStream) obj;
        return Objects.equals(destinationStreamArn(), other.destinationStreamArn()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WriteEventStream").add("DestinationStreamArn", destinationStreamArn()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationStreamArn":
            return Optional.ofNullable(clazz.cast(destinationStreamArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationStreamArn", DESTINATION_STREAM_ARN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WriteEventStream, T> g) {
        return obj -> g.apply((WriteEventStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteEventStream> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery
         * stream that you want to publish event data to.
         * </p>
         * <p>
         * For a Kinesis data stream, the ARN format is:
         * arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable>account
         * -id</replaceable>:stream/<replaceable>stream_name</replaceable>
         * </p>
         * <p>
         * For a Kinesis Data Firehose delivery stream, the ARN format is:
         * arn:aws:firehose:<replaceable>region</replaceable
         * >:<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable>
         * </p>
         * 
         * @param destinationStreamArn
         *        The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose
         *        delivery stream that you want to publish event data to.</p>
         *        <p>
         *        For a Kinesis data stream, the ARN format is:
         *        arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable
         *        >account-id</replaceable>:stream/<replaceable>stream_name</replaceable>
         *        </p>
         *        <p>
         *        For a Kinesis Data Firehose delivery stream, the ARN format is:
         *        arn:aws:firehose:<replaceable>region</replaceable
         *        >:<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationStreamArn(String destinationStreamArn);

        /**
         * <p>
         * The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data to
         * the stream in your AWS account.
         * </p>
         * 
         * @param roleArn
         *        The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event
         *        data to the stream in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String destinationStreamArn;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteEventStream model) {
            destinationStreamArn(model.destinationStreamArn);
            roleArn(model.roleArn);
        }

        public final String getDestinationStreamArn() {
            return destinationStreamArn;
        }

        public final void setDestinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
        }

        @Override
        public final Builder destinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public WriteEventStream build() {
            return new WriteEventStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
