/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEventsResponse extends PinpointResponse implements
        ToCopyableBuilder<PutEventsResponse.Builder, PutEventsResponse> {
    private static final SdkField<EventsResponse> EVENTS_RESPONSE_FIELD = SdkField
            .<EventsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("EventsResponse")
            .getter(getter(PutEventsResponse::eventsResponse))
            .setter(setter(Builder::eventsResponse))
            .constructor(EventsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EventsResponse eventsResponse;

    private PutEventsResponse(BuilderImpl builder) {
        super(builder);
        this.eventsResponse = builder.eventsResponse;
    }

    /**
     * Returns the value of the EventsResponse property for this object.
     * 
     * @return The value of the EventsResponse property for this object.
     */
    public final EventsResponse eventsResponse() {
        return eventsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventsResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsResponse)) {
            return false;
        }
        PutEventsResponse other = (PutEventsResponse) obj;
        return Objects.equals(eventsResponse(), other.eventsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEventsResponse").add("EventsResponse", eventsResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventsResponse":
            return Optional.ofNullable(clazz.cast(eventsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventsResponse", EVENTS_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEventsResponse, T> g) {
        return obj -> g.apply((PutEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutEventsResponse> {
        /**
         * Sets the value of the EventsResponse property for this object.
         *
         * @param eventsResponse
         *        The new value for the EventsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsResponse(EventsResponse eventsResponse);

        /**
         * Sets the value of the EventsResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EventsResponse.Builder} avoiding the need
         * to create one manually via {@link EventsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventsResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #eventsResponse(EventsResponse)}.
         * 
         * @param eventsResponse
         *        a consumer that will call methods on {@link EventsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventsResponse(EventsResponse)
         */
        default Builder eventsResponse(Consumer<EventsResponse.Builder> eventsResponse) {
            return eventsResponse(EventsResponse.builder().applyMutation(eventsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private EventsResponse eventsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsResponse model) {
            super(model);
            eventsResponse(model.eventsResponse);
        }

        public final EventsResponse.Builder getEventsResponse() {
            return eventsResponse != null ? eventsResponse.toBuilder() : null;
        }

        public final void setEventsResponse(EventsResponse.BuilderImpl eventsResponse) {
            this.eventsResponse = eventsResponse != null ? eventsResponse.build() : null;
        }

        @Override
        public final Builder eventsResponse(EventsResponse eventsResponse) {
            this.eventsResponse = eventsResponse;
            return this;
        }

        @Override
        public PutEventsResponse build() {
            return new PutEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
