/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class MapOfEventItemResponseCopier {
    static Map<String, EventItemResponse> copy(Map<String, ? extends EventItemResponse> mapOfEventItemResponseParam) {
        Map<String, EventItemResponse> map;
        if (mapOfEventItemResponseParam == null || mapOfEventItemResponseParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, EventItemResponse> modifiableMap = new LinkedHashMap<>(mapOfEventItemResponseParam.size());
            mapOfEventItemResponseParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, EventItemResponse> copyFromBuilder(
            Map<String, ? extends EventItemResponse.Builder> mapOfEventItemResponseParam) {
        Map<String, EventItemResponse> map;
        if (mapOfEventItemResponseParam == null || mapOfEventItemResponseParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, EventItemResponse> modifiableMap = new LinkedHashMap<>(mapOfEventItemResponseParam.size());
            mapOfEventItemResponseParam.forEach((key, value) -> {
                EventItemResponse member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, EventItemResponse.Builder> copyToBuilder(
            Map<String, ? extends EventItemResponse> mapOfEventItemResponseParam) {
        Map<String, EventItemResponse.Builder> map;
        if (mapOfEventItemResponseParam == null || mapOfEventItemResponseParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, EventItemResponse.Builder> modifiableMap = new LinkedHashMap<>(mapOfEventItemResponseParam.size());
            mapOfEventItemResponseParam.forEach((key, value) -> {
                EventItemResponse.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
