/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GCMChannelRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GCMChannelRequest> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiKey").getter(GCMChannelRequest.getter(GCMChannelRequest::apiKey)).setter(GCMChannelRequest.setter(Builder::apiKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKey").build()}).build();
    private static final SdkField<String> DEFAULT_AUTHENTICATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultAuthenticationMethod").getter(GCMChannelRequest.getter(GCMChannelRequest::defaultAuthenticationMethod)).setter(GCMChannelRequest.setter(Builder::defaultAuthenticationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAuthenticationMethod").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(GCMChannelRequest.getter(GCMChannelRequest::enabled)).setter(GCMChannelRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> SERVICE_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceJson").getter(GCMChannelRequest.getter(GCMChannelRequest::serviceJson)).setter(GCMChannelRequest.setter(Builder::serviceJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceJson").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD, DEFAULT_AUTHENTICATION_METHOD_FIELD, ENABLED_FIELD, SERVICE_JSON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GCMChannelRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String apiKey;
    private final String defaultAuthenticationMethod;
    private final Boolean enabled;
    private final String serviceJson;

    private GCMChannelRequest(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.defaultAuthenticationMethod = builder.defaultAuthenticationMethod;
        this.enabled = builder.enabled;
        this.serviceJson = builder.serviceJson;
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String defaultAuthenticationMethod() {
        return this.defaultAuthenticationMethod;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String serviceJson() {
        return this.serviceJson;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAuthenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceJson());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GCMChannelRequest)) {
            return false;
        }
        GCMChannelRequest other = (GCMChannelRequest)obj;
        return Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.defaultAuthenticationMethod(), other.defaultAuthenticationMethod()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.serviceJson(), other.serviceJson());
    }

    public final String toString() {
        return ToString.builder((String)"GCMChannelRequest").add("ApiKey", (Object)this.apiKey()).add("DefaultAuthenticationMethod", (Object)this.defaultAuthenticationMethod()).add("Enabled", (Object)this.enabled()).add("ServiceJson", (Object)this.serviceJson()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "DefaultAuthenticationMethod": {
                return Optional.ofNullable(clazz.cast(this.defaultAuthenticationMethod()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ServiceJson": {
                return Optional.ofNullable(clazz.cast(this.serviceJson()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApiKey", API_KEY_FIELD);
        map.put("DefaultAuthenticationMethod", DEFAULT_AUTHENTICATION_METHOD_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("ServiceJson", SERVICE_JSON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GCMChannelRequest, T> g) {
        return obj -> g.apply((GCMChannelRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiKey;
        private String defaultAuthenticationMethod;
        private Boolean enabled;
        private String serviceJson;

        private BuilderImpl() {
        }

        private BuilderImpl(GCMChannelRequest model) {
            this.apiKey(model.apiKey);
            this.defaultAuthenticationMethod(model.defaultAuthenticationMethod);
            this.enabled(model.enabled);
            this.serviceJson(model.serviceJson);
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getDefaultAuthenticationMethod() {
            return this.defaultAuthenticationMethod;
        }

        public final void setDefaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
        }

        @Override
        public final Builder defaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getServiceJson() {
            return this.serviceJson;
        }

        public final void setServiceJson(String serviceJson) {
            this.serviceJson = serviceJson;
        }

        @Override
        public final Builder serviceJson(String serviceJson) {
            this.serviceJson = serviceJson;
            return this;
        }

        public GCMChannelRequest build() {
            return new GCMChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GCMChannelRequest> {
        public Builder apiKey(String var1);

        public Builder defaultAuthenticationMethod(String var1);

        public Builder enabled(Boolean var1);

        public Builder serviceJson(String var1);
    }
}

