/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.CustomDeliveryConfiguration;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteTreatmentResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WriteTreatmentResource> {
    private static final SdkField<CustomDeliveryConfiguration> CUSTOM_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomDeliveryConfiguration").getter(WriteTreatmentResource.getter(WriteTreatmentResource::customDeliveryConfiguration)).setter(WriteTreatmentResource.setter(Builder::customDeliveryConfiguration)).constructor(CustomDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDeliveryConfiguration").build()}).build();
    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MessageConfiguration").getter(WriteTreatmentResource.getter(WriteTreatmentResource::messageConfiguration)).setter(WriteTreatmentResource.setter(Builder::messageConfiguration)).constructor(MessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(WriteTreatmentResource.getter(WriteTreatmentResource::schedule)).setter(WriteTreatmentResource.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<Integer> SIZE_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SizePercent").getter(WriteTreatmentResource.getter(WriteTreatmentResource::sizePercent)).setter(WriteTreatmentResource.setter(Builder::sizePercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizePercent").build()}).build();
    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateConfiguration").getter(WriteTreatmentResource.getter(WriteTreatmentResource::templateConfiguration)).setter(WriteTreatmentResource.setter(Builder::templateConfiguration)).constructor(TemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build()}).build();
    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatmentDescription").getter(WriteTreatmentResource.getter(WriteTreatmentResource::treatmentDescription)).setter(WriteTreatmentResource.setter(Builder::treatmentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build()}).build();
    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatmentName").getter(WriteTreatmentResource.getter(WriteTreatmentResource::treatmentName)).setter(WriteTreatmentResource.setter(Builder::treatmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DELIVERY_CONFIGURATION_FIELD, MESSAGE_CONFIGURATION_FIELD, SCHEDULE_FIELD, SIZE_PERCENT_FIELD, TEMPLATE_CONFIGURATION_FIELD, TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomDeliveryConfiguration", CUSTOM_DELIVERY_CONFIGURATION_FIELD);
            this.put("MessageConfiguration", MESSAGE_CONFIGURATION_FIELD);
            this.put("Schedule", SCHEDULE_FIELD);
            this.put("SizePercent", SIZE_PERCENT_FIELD);
            this.put("TemplateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
            this.put("TreatmentDescription", TREATMENT_DESCRIPTION_FIELD);
            this.put("TreatmentName", TREATMENT_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CustomDeliveryConfiguration customDeliveryConfiguration;
    private final MessageConfiguration messageConfiguration;
    private final Schedule schedule;
    private final Integer sizePercent;
    private final TemplateConfiguration templateConfiguration;
    private final String treatmentDescription;
    private final String treatmentName;

    private WriteTreatmentResource(BuilderImpl builder) {
        this.customDeliveryConfiguration = builder.customDeliveryConfiguration;
        this.messageConfiguration = builder.messageConfiguration;
        this.schedule = builder.schedule;
        this.sizePercent = builder.sizePercent;
        this.templateConfiguration = builder.templateConfiguration;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    public final CustomDeliveryConfiguration customDeliveryConfiguration() {
        return this.customDeliveryConfiguration;
    }

    public final MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final Integer sizePercent() {
        return this.sizePercent;
    }

    public final TemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public final String treatmentDescription() {
        return this.treatmentDescription;
    }

    public final String treatmentName() {
        return this.treatmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizePercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteTreatmentResource)) {
            return false;
        }
        WriteTreatmentResource other = (WriteTreatmentResource)obj;
        return Objects.equals(this.customDeliveryConfiguration(), other.customDeliveryConfiguration()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.sizePercent(), other.sizePercent()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.treatmentDescription(), other.treatmentDescription()) && Objects.equals(this.treatmentName(), other.treatmentName());
    }

    public final String toString() {
        return ToString.builder((String)"WriteTreatmentResource").add("CustomDeliveryConfiguration", (Object)this.customDeliveryConfiguration()).add("MessageConfiguration", (Object)this.messageConfiguration()).add("Schedule", (Object)this.schedule()).add("SizePercent", (Object)this.sizePercent()).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("TreatmentDescription", (Object)this.treatmentDescription()).add("TreatmentName", (Object)this.treatmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customDeliveryConfiguration()));
            }
            case "MessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.messageConfiguration()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "SizePercent": {
                return Optional.ofNullable(clazz.cast(this.sizePercent()));
            }
            case "TemplateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "TreatmentDescription": {
                return Optional.ofNullable(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.ofNullable(clazz.cast(this.treatmentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WriteTreatmentResource, T> g) {
        return obj -> g.apply((WriteTreatmentResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CustomDeliveryConfiguration customDeliveryConfiguration;
        private MessageConfiguration messageConfiguration;
        private Schedule schedule;
        private Integer sizePercent;
        private TemplateConfiguration templateConfiguration;
        private String treatmentDescription;
        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteTreatmentResource model) {
            this.customDeliveryConfiguration(model.customDeliveryConfiguration);
            this.messageConfiguration(model.messageConfiguration);
            this.schedule(model.schedule);
            this.sizePercent(model.sizePercent);
            this.templateConfiguration(model.templateConfiguration);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
        }

        public final CustomDeliveryConfiguration.Builder getCustomDeliveryConfiguration() {
            return this.customDeliveryConfiguration != null ? this.customDeliveryConfiguration.toBuilder() : null;
        }

        public final void setCustomDeliveryConfiguration(CustomDeliveryConfiguration.BuilderImpl customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration != null ? customDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder customDeliveryConfiguration(CustomDeliveryConfiguration customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration;
            return this;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Integer getSizePercent() {
            return this.sizePercent;
        }

        public final void setSizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
        }

        @Override
        public final Builder sizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public WriteTreatmentResource build() {
            return new WriteTreatmentResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WriteTreatmentResource> {
        public Builder customDeliveryConfiguration(CustomDeliveryConfiguration var1);

        default public Builder customDeliveryConfiguration(Consumer<CustomDeliveryConfiguration.Builder> customDeliveryConfiguration) {
            return this.customDeliveryConfiguration((CustomDeliveryConfiguration)((CustomDeliveryConfiguration.Builder)CustomDeliveryConfiguration.builder().applyMutation(customDeliveryConfiguration)).build());
        }

        public Builder messageConfiguration(MessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((MessageConfiguration)((MessageConfiguration.Builder)MessageConfiguration.builder().applyMutation(messageConfiguration)).build());
        }

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder sizePercent(Integer var1);

        public Builder templateConfiguration(TemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((TemplateConfiguration)((TemplateConfiguration.Builder)TemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);
    }
}

