/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.VerifyOTPMessageRequestParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyOtpMessageRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, VerifyOtpMessageRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(VerifyOtpMessageRequest.getter(VerifyOtpMessageRequest::applicationId)).setter(VerifyOtpMessageRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<VerifyOTPMessageRequestParameters> VERIFY_OTP_MESSAGE_REQUEST_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerifyOTPMessageRequestParameters").getter(VerifyOtpMessageRequest.getter(VerifyOtpMessageRequest::verifyOTPMessageRequestParameters)).setter(VerifyOtpMessageRequest.setter(Builder::verifyOTPMessageRequestParameters)).constructor(VerifyOTPMessageRequestParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifyOTPMessageRequestParameters").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, VERIFY_OTP_MESSAGE_REQUEST_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("application-id", APPLICATION_ID_FIELD);
            this.put("VerifyOTPMessageRequestParameters", VERIFY_OTP_MESSAGE_REQUEST_PARAMETERS_FIELD);
        }
    });
    private final String applicationId;
    private final VerifyOTPMessageRequestParameters verifyOTPMessageRequestParameters;

    private VerifyOtpMessageRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.verifyOTPMessageRequestParameters = builder.verifyOTPMessageRequestParameters;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final VerifyOTPMessageRequestParameters verifyOTPMessageRequestParameters() {
        return this.verifyOTPMessageRequestParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifyOTPMessageRequestParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyOtpMessageRequest)) {
            return false;
        }
        VerifyOtpMessageRequest other = (VerifyOtpMessageRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.verifyOTPMessageRequestParameters(), other.verifyOTPMessageRequestParameters());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyOtpMessageRequest").add("ApplicationId", (Object)this.applicationId()).add("VerifyOTPMessageRequestParameters", (Object)this.verifyOTPMessageRequestParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "VerifyOTPMessageRequestParameters": {
                return Optional.ofNullable(clazz.cast(this.verifyOTPMessageRequestParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VerifyOtpMessageRequest, T> g) {
        return obj -> g.apply((VerifyOtpMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private VerifyOTPMessageRequestParameters verifyOTPMessageRequestParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyOtpMessageRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.verifyOTPMessageRequestParameters(model.verifyOTPMessageRequestParameters);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final VerifyOTPMessageRequestParameters.Builder getVerifyOTPMessageRequestParameters() {
            return this.verifyOTPMessageRequestParameters != null ? this.verifyOTPMessageRequestParameters.toBuilder() : null;
        }

        public final void setVerifyOTPMessageRequestParameters(VerifyOTPMessageRequestParameters.BuilderImpl verifyOTPMessageRequestParameters) {
            this.verifyOTPMessageRequestParameters = verifyOTPMessageRequestParameters != null ? verifyOTPMessageRequestParameters.build() : null;
        }

        @Override
        public final Builder verifyOTPMessageRequestParameters(VerifyOTPMessageRequestParameters verifyOTPMessageRequestParameters) {
            this.verifyOTPMessageRequestParameters = verifyOTPMessageRequestParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyOtpMessageRequest build() {
            return new VerifyOtpMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyOtpMessageRequest> {
        public Builder applicationId(String var1);

        public Builder verifyOTPMessageRequestParameters(VerifyOTPMessageRequestParameters var1);

        default public Builder verifyOTPMessageRequestParameters(Consumer<VerifyOTPMessageRequestParameters.Builder> verifyOTPMessageRequestParameters) {
            return this.verifyOTPMessageRequestParameters((VerifyOTPMessageRequestParameters)((VerifyOTPMessageRequestParameters.Builder)VerifyOTPMessageRequestParameters.builder().applyMutation(verifyOTPMessageRequestParameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

