/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.Event;
import software.amazon.awssdk.services.pinpoint.model.MapOfEventCopier;
import software.amazon.awssdk.services.pinpoint.model.PublicEndpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsBatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventsBatch> {
    private static final SdkField<PublicEndpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoint").getter(EventsBatch.getter(EventsBatch::endpoint)).setter(EventsBatch.setter(Builder::endpoint)).constructor(PublicEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Map<String, Event>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Events").getter(EventsBatch.getter(EventsBatch::events)).setter(EventsBatch.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Event::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Endpoint", ENDPOINT_FIELD);
            this.put("Events", EVENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final PublicEndpoint endpoint;
    private final Map<String, Event> events;

    private EventsBatch(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.events = builder.events;
    }

    public final PublicEndpoint endpoint() {
        return this.endpoint;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructMap);
    }

    public final Map<String, Event> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsBatch)) {
            return false;
        }
        EventsBatch other = (EventsBatch)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events());
    }

    public final String toString() {
        return ToString.builder((String)"EventsBatch").add("Endpoint", (Object)this.endpoint()).add("Events", this.hasEvents() ? this.events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EventsBatch, T> g) {
        return obj -> g.apply((EventsBatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PublicEndpoint endpoint;
        private Map<String, Event> events = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsBatch model) {
            this.endpoint(model.endpoint);
            this.events(model.events);
        }

        public final PublicEndpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(PublicEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(PublicEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Map<String, Event.Builder> getEvents() {
            Map<String, Event.Builder> result = MapOfEventCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEvents(Map<String, Event.BuilderImpl> events) {
            this.events = MapOfEventCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Map<String, Event> events) {
            this.events = MapOfEventCopier.copy(events);
            return this;
        }

        public EventsBatch build() {
            return new EventsBatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventsBatch> {
        public Builder endpoint(PublicEndpoint var1);

        default public Builder endpoint(Consumer<PublicEndpoint.Builder> endpoint) {
            return this.endpoint((PublicEndpoint)((PublicEndpoint.Builder)PublicEndpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder events(Map<String, Event> var1);
    }
}

