/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.Template;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateConfiguration> {
    private static final SdkField<Template> EMAIL_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailTemplate").getter(TemplateConfiguration.getter(TemplateConfiguration::emailTemplate)).setter(TemplateConfiguration.setter(Builder::emailTemplate)).constructor(Template::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailTemplate").build()}).build();
    private static final SdkField<Template> PUSH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PushTemplate").getter(TemplateConfiguration.getter(TemplateConfiguration::pushTemplate)).setter(TemplateConfiguration.setter(Builder::pushTemplate)).constructor(Template::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushTemplate").build()}).build();
    private static final SdkField<Template> SMS_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SMSTemplate").getter(TemplateConfiguration.getter(TemplateConfiguration::smsTemplate)).setter(TemplateConfiguration.setter(Builder::smsTemplate)).constructor(Template::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSTemplate").build()}).build();
    private static final SdkField<Template> VOICE_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VoiceTemplate").getter(TemplateConfiguration.getter(TemplateConfiguration::voiceTemplate)).setter(TemplateConfiguration.setter(Builder::voiceTemplate)).constructor(Template::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceTemplate").build()}).build();
    private static final SdkField<Template> IN_APP_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InAppTemplate").getter(TemplateConfiguration.getter(TemplateConfiguration::inAppTemplate)).setter(TemplateConfiguration.setter(Builder::inAppTemplate)).constructor(Template::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InAppTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_TEMPLATE_FIELD, PUSH_TEMPLATE_FIELD, SMS_TEMPLATE_FIELD, VOICE_TEMPLATE_FIELD, IN_APP_TEMPLATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EmailTemplate", EMAIL_TEMPLATE_FIELD);
            this.put("PushTemplate", PUSH_TEMPLATE_FIELD);
            this.put("SMSTemplate", SMS_TEMPLATE_FIELD);
            this.put("VoiceTemplate", VOICE_TEMPLATE_FIELD);
            this.put("InAppTemplate", IN_APP_TEMPLATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Template emailTemplate;
    private final Template pushTemplate;
    private final Template smsTemplate;
    private final Template voiceTemplate;
    private final Template inAppTemplate;

    private TemplateConfiguration(BuilderImpl builder) {
        this.emailTemplate = builder.emailTemplate;
        this.pushTemplate = builder.pushTemplate;
        this.smsTemplate = builder.smsTemplate;
        this.voiceTemplate = builder.voiceTemplate;
        this.inAppTemplate = builder.inAppTemplate;
    }

    public final Template emailTemplate() {
        return this.emailTemplate;
    }

    public final Template pushTemplate() {
        return this.pushTemplate;
    }

    public final Template smsTemplate() {
        return this.smsTemplate;
    }

    public final Template voiceTemplate() {
        return this.voiceTemplate;
    }

    public final Template inAppTemplate() {
        return this.inAppTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emailTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.pushTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inAppTemplate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateConfiguration)) {
            return false;
        }
        TemplateConfiguration other = (TemplateConfiguration)obj;
        return Objects.equals(this.emailTemplate(), other.emailTemplate()) && Objects.equals(this.pushTemplate(), other.pushTemplate()) && Objects.equals(this.smsTemplate(), other.smsTemplate()) && Objects.equals(this.voiceTemplate(), other.voiceTemplate()) && Objects.equals(this.inAppTemplate(), other.inAppTemplate());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateConfiguration").add("EmailTemplate", (Object)this.emailTemplate()).add("PushTemplate", (Object)this.pushTemplate()).add("SMSTemplate", (Object)this.smsTemplate()).add("VoiceTemplate", (Object)this.voiceTemplate()).add("InAppTemplate", (Object)this.inAppTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailTemplate": {
                return Optional.ofNullable(clazz.cast(this.emailTemplate()));
            }
            case "PushTemplate": {
                return Optional.ofNullable(clazz.cast(this.pushTemplate()));
            }
            case "SMSTemplate": {
                return Optional.ofNullable(clazz.cast(this.smsTemplate()));
            }
            case "VoiceTemplate": {
                return Optional.ofNullable(clazz.cast(this.voiceTemplate()));
            }
            case "InAppTemplate": {
                return Optional.ofNullable(clazz.cast(this.inAppTemplate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TemplateConfiguration, T> g) {
        return obj -> g.apply((TemplateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Template emailTemplate;
        private Template pushTemplate;
        private Template smsTemplate;
        private Template voiceTemplate;
        private Template inAppTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateConfiguration model) {
            this.emailTemplate(model.emailTemplate);
            this.pushTemplate(model.pushTemplate);
            this.smsTemplate(model.smsTemplate);
            this.voiceTemplate(model.voiceTemplate);
            this.inAppTemplate(model.inAppTemplate);
        }

        public final Template.Builder getEmailTemplate() {
            return this.emailTemplate != null ? this.emailTemplate.toBuilder() : null;
        }

        public final void setEmailTemplate(Template.BuilderImpl emailTemplate) {
            this.emailTemplate = emailTemplate != null ? emailTemplate.build() : null;
        }

        @Override
        public final Builder emailTemplate(Template emailTemplate) {
            this.emailTemplate = emailTemplate;
            return this;
        }

        public final Template.Builder getPushTemplate() {
            return this.pushTemplate != null ? this.pushTemplate.toBuilder() : null;
        }

        public final void setPushTemplate(Template.BuilderImpl pushTemplate) {
            this.pushTemplate = pushTemplate != null ? pushTemplate.build() : null;
        }

        @Override
        public final Builder pushTemplate(Template pushTemplate) {
            this.pushTemplate = pushTemplate;
            return this;
        }

        public final Template.Builder getSmsTemplate() {
            return this.smsTemplate != null ? this.smsTemplate.toBuilder() : null;
        }

        public final void setSmsTemplate(Template.BuilderImpl smsTemplate) {
            this.smsTemplate = smsTemplate != null ? smsTemplate.build() : null;
        }

        @Override
        public final Builder smsTemplate(Template smsTemplate) {
            this.smsTemplate = smsTemplate;
            return this;
        }

        public final Template.Builder getVoiceTemplate() {
            return this.voiceTemplate != null ? this.voiceTemplate.toBuilder() : null;
        }

        public final void setVoiceTemplate(Template.BuilderImpl voiceTemplate) {
            this.voiceTemplate = voiceTemplate != null ? voiceTemplate.build() : null;
        }

        @Override
        public final Builder voiceTemplate(Template voiceTemplate) {
            this.voiceTemplate = voiceTemplate;
            return this;
        }

        public final Template.Builder getInAppTemplate() {
            return this.inAppTemplate != null ? this.inAppTemplate.toBuilder() : null;
        }

        public final void setInAppTemplate(Template.BuilderImpl inAppTemplate) {
            this.inAppTemplate = inAppTemplate != null ? inAppTemplate.build() : null;
        }

        @Override
        public final Builder inAppTemplate(Template inAppTemplate) {
            this.inAppTemplate = inAppTemplate;
            return this;
        }

        public TemplateConfiguration build() {
            return new TemplateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateConfiguration> {
        public Builder emailTemplate(Template var1);

        default public Builder emailTemplate(Consumer<Template.Builder> emailTemplate) {
            return this.emailTemplate((Template)((Template.Builder)Template.builder().applyMutation(emailTemplate)).build());
        }

        public Builder pushTemplate(Template var1);

        default public Builder pushTemplate(Consumer<Template.Builder> pushTemplate) {
            return this.pushTemplate((Template)((Template.Builder)Template.builder().applyMutation(pushTemplate)).build());
        }

        public Builder smsTemplate(Template var1);

        default public Builder smsTemplate(Consumer<Template.Builder> smsTemplate) {
            return this.smsTemplate((Template)((Template.Builder)Template.builder().applyMutation(smsTemplate)).build());
        }

        public Builder voiceTemplate(Template var1);

        default public Builder voiceTemplate(Consumer<Template.Builder> voiceTemplate) {
            return this.voiceTemplate((Template)((Template.Builder)Template.builder().applyMutation(voiceTemplate)).build());
        }

        public Builder inAppTemplate(Template var1);

        default public Builder inAppTemplate(Consumer<Template.Builder> inAppTemplate) {
            return this.inAppTemplate((Template)((Template.Builder)Template.builder().applyMutation(inAppTemplate)).build());
        }
    }
}

