/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a
 * Dimensions object or a SegmentGroups object, but not both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteSegmentRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<WriteSegmentRequest.Builder, WriteSegmentRequest> {
    private static final SdkField<SegmentDimensions> DIMENSIONS_FIELD = SdkField
            .<SegmentDimensions> builder(MarshallingType.SDK_POJO).memberName("Dimensions")
            .getter(getter(WriteSegmentRequest::dimensions)).setter(setter(Builder::dimensions))
            .constructor(SegmentDimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(WriteSegmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<SegmentGroupList> SEGMENT_GROUPS_FIELD = SdkField
            .<SegmentGroupList> builder(MarshallingType.SDK_POJO).memberName("SegmentGroups")
            .getter(getter(WriteSegmentRequest::segmentGroups)).setter(setter(Builder::segmentGroups))
            .constructor(SegmentGroupList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentGroups").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(WriteSegmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, NAME_FIELD,
            SEGMENT_GROUPS_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SegmentDimensions dimensions;

    private final String name;

    private final SegmentGroupList segmentGroups;

    private final Map<String, String> tags;

    private WriteSegmentRequest(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.name = builder.name;
        this.segmentGroups = builder.segmentGroups;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The criteria that define the dimensions for the segment.
     * </p>
     * 
     * @return The criteria that define the dimensions for the segment.
     */
    public final SegmentDimensions dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The name of the segment.
     * </p>
     * 
     * @return The name of the segment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The segment group to use and the dimensions to apply to the group's base segments in order to build the segment.
     * A segment group can consist of zero or more base segments. Your request can include only one segment group.
     * </p>
     * 
     * @return The segment group to use and the dimensions to apply to the group's base segments in order to build the
     *         segment. A segment group can consist of zero or more base segments. Your request can include only one
     *         segment group.
     */
    public final SegmentGroupList segmentGroups() {
        return segmentGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <note>
     * <p>
     * As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not
     * processed and an error code is not returned. To manage tags we recommend using either <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API
     * Reference for Amazon Pinpoint</i>, <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
     * >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href=
     * "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
     * >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.
     * </p>
     * </note>
     * <p>
     * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the segment. Each
     * tag consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags
     *         is not processed and an error code is not returned. To manage tags we recommend using either <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the
     *         <i>API Reference for Amazon Pinpoint</i>, <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
     *         >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href=
     *         "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
     *         >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(segmentGroups());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteSegmentRequest)) {
            return false;
        }
        WriteSegmentRequest other = (WriteSegmentRequest) obj;
        return Objects.equals(dimensions(), other.dimensions()) && Objects.equals(name(), other.name())
                && Objects.equals(segmentGroups(), other.segmentGroups()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WriteSegmentRequest").add("Dimensions", dimensions()).add("Name", name())
                .add("SegmentGroups", segmentGroups()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SegmentGroups":
            return Optional.ofNullable(clazz.cast(segmentGroups()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteSegmentRequest, T> g) {
        return obj -> g.apply((WriteSegmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteSegmentRequest> {
        /**
         * <p>
         * The criteria that define the dimensions for the segment.
         * </p>
         * 
         * @param dimensions
         *        The criteria that define the dimensions for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(SegmentDimensions dimensions);

        /**
         * <p>
         * The criteria that define the dimensions for the segment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SegmentDimensions.Builder} avoiding the
         * need to create one manually via {@link SegmentDimensions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SegmentDimensions.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(SegmentDimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link SegmentDimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(SegmentDimensions)
         */
        default Builder dimensions(Consumer<SegmentDimensions.Builder> dimensions) {
            return dimensions(SegmentDimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * The name of the segment.
         * </p>
         * 
         * @param name
         *        The name of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The segment group to use and the dimensions to apply to the group's base segments in order to build the
         * segment. A segment group can consist of zero or more base segments. Your request can include only one segment
         * group.
         * </p>
         * 
         * @param segmentGroups
         *        The segment group to use and the dimensions to apply to the group's base segments in order to build
         *        the segment. A segment group can consist of zero or more base segments. Your request can include only
         *        one segment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentGroups(SegmentGroupList segmentGroups);

        /**
         * <p>
         * The segment group to use and the dimensions to apply to the group's base segments in order to build the
         * segment. A segment group can consist of zero or more base segments. Your request can include only one segment
         * group.
         * </p>
         * This is a convenience method that creates an instance of the {@link SegmentGroupList.Builder} avoiding the
         * need to create one manually via {@link SegmentGroupList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SegmentGroupList.Builder#build()} is called immediately and its
         * result is passed to {@link #segmentGroups(SegmentGroupList)}.
         * 
         * @param segmentGroups
         *        a consumer that will call methods on {@link SegmentGroupList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentGroups(SegmentGroupList)
         */
        default Builder segmentGroups(Consumer<SegmentGroupList.Builder> segmentGroups) {
            return segmentGroups(SegmentGroupList.builder().applyMutation(segmentGroups).build());
        }

        /**
         * <note>
         * <p>
         * As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is
         * not processed and an error code is not returned. To manage tags we recommend using either <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API
         * Reference for Amazon Pinpoint</i>, <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
         * >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href=
         * "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
         * >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.
         * </p>
         * </note>
         * <p>
         * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the segment.
         * Each tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in
         *        tags is not processed and an error code is not returned. To manage tags we recommend using either <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the
         *        <i>API Reference for Amazon Pinpoint</i>, <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
         *        >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a
         *        href=
         *        "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
         *        >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private SegmentDimensions dimensions;

        private String name;

        private SegmentGroupList segmentGroups;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WriteSegmentRequest model) {
            dimensions(model.dimensions);
            name(model.name);
            segmentGroups(model.segmentGroups);
            tags(model.tags);
        }

        public final SegmentDimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        public final void setDimensions(SegmentDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SegmentGroupList.Builder getSegmentGroups() {
            return segmentGroups != null ? segmentGroups.toBuilder() : null;
        }

        public final void setSegmentGroups(SegmentGroupList.BuilderImpl segmentGroups) {
            this.segmentGroups = segmentGroups != null ? segmentGroups.build() : null;
        }

        @Override
        public final Builder segmentGroups(SegmentGroupList segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public WriteSegmentRequest build() {
            return new WriteSegmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
