/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Include {
    ALL("ALL"),
    ANY("ANY"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Include> VALUE_MAP;
    private final String value;

    private Include(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Include fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Include> knownValues() {
        EnumSet<Include> knownValues = EnumSet.allOf(Include.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Include.class, Include::toString);
    }
}

