/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBaiduChannelResponse extends PinpointResponse implements
        ToCopyableBuilder<DeleteBaiduChannelResponse.Builder, DeleteBaiduChannelResponse> {
    private static final SdkField<BaiduChannelResponse> BAIDU_CHANNEL_RESPONSE_FIELD = SdkField
            .<BaiduChannelResponse> builder(MarshallingType.SDK_POJO)
            .memberName("BaiduChannelResponse")
            .getter(getter(DeleteBaiduChannelResponse::baiduChannelResponse))
            .setter(setter(Builder::baiduChannelResponse))
            .constructor(BaiduChannelResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaiduChannelResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BAIDU_CHANNEL_RESPONSE_FIELD));

    private final BaiduChannelResponse baiduChannelResponse;

    private DeleteBaiduChannelResponse(BuilderImpl builder) {
        super(builder);
        this.baiduChannelResponse = builder.baiduChannelResponse;
    }

    /**
     * Returns the value of the BaiduChannelResponse property for this object.
     * 
     * @return The value of the BaiduChannelResponse property for this object.
     */
    public final BaiduChannelResponse baiduChannelResponse() {
        return baiduChannelResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baiduChannelResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBaiduChannelResponse)) {
            return false;
        }
        DeleteBaiduChannelResponse other = (DeleteBaiduChannelResponse) obj;
        return Objects.equals(baiduChannelResponse(), other.baiduChannelResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBaiduChannelResponse").add("BaiduChannelResponse", baiduChannelResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaiduChannelResponse":
            return Optional.ofNullable(clazz.cast(baiduChannelResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBaiduChannelResponse, T> g) {
        return obj -> g.apply((DeleteBaiduChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBaiduChannelResponse> {
        /**
         * Sets the value of the BaiduChannelResponse property for this object.
         *
         * @param baiduChannelResponse
         *        The new value for the BaiduChannelResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baiduChannelResponse(BaiduChannelResponse baiduChannelResponse);

        /**
         * Sets the value of the BaiduChannelResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BaiduChannelResponse.Builder} avoiding
         * the need to create one manually via {@link BaiduChannelResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BaiduChannelResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #baiduChannelResponse(BaiduChannelResponse)}.
         * 
         * @param baiduChannelResponse
         *        a consumer that will call methods on {@link BaiduChannelResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baiduChannelResponse(BaiduChannelResponse)
         */
        default Builder baiduChannelResponse(Consumer<BaiduChannelResponse.Builder> baiduChannelResponse) {
            return baiduChannelResponse(BaiduChannelResponse.builder().applyMutation(baiduChannelResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private BaiduChannelResponse baiduChannelResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBaiduChannelResponse model) {
            super(model);
            baiduChannelResponse(model.baiduChannelResponse);
        }

        public final BaiduChannelResponse.Builder getBaiduChannelResponse() {
            return baiduChannelResponse != null ? baiduChannelResponse.toBuilder() : null;
        }

        public final void setBaiduChannelResponse(BaiduChannelResponse.BuilderImpl baiduChannelResponse) {
            this.baiduChannelResponse = baiduChannelResponse != null ? baiduChannelResponse.build() : null;
        }

        @Override
        public final Builder baiduChannelResponse(BaiduChannelResponse baiduChannelResponse) {
            this.baiduChannelResponse = baiduChannelResponse;
            return this;
        }

        @Override
        public DeleteBaiduChannelResponse build() {
            return new DeleteBaiduChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
