/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.ExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExportJobRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, CreateExportJobRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateExportJobRequest.getter(CreateExportJobRequest::applicationId)).setter(CreateExportJobRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<ExportJobRequest> EXPORT_JOB_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportJobRequest").getter(CreateExportJobRequest.getter(CreateExportJobRequest::exportJobRequest)).setter(CreateExportJobRequest.setter(Builder::exportJobRequest)).constructor(ExportJobRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, EXPORT_JOB_REQUEST_FIELD));
    private final String applicationId;
    private final ExportJobRequest exportJobRequest;

    private CreateExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.exportJobRequest = builder.exportJobRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final ExportJobRequest exportJobRequest() {
        return this.exportJobRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportJobRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportJobRequest)) {
            return false;
        }
        CreateExportJobRequest other = (CreateExportJobRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.exportJobRequest(), other.exportJobRequest());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExportJobRequest").add("ApplicationId", (Object)this.applicationId()).add("ExportJobRequest", (Object)this.exportJobRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ExportJobRequest": {
                return Optional.ofNullable(clazz.cast(this.exportJobRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExportJobRequest, T> g) {
        return obj -> g.apply((CreateExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private ExportJobRequest exportJobRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportJobRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.exportJobRequest(model.exportJobRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final ExportJobRequest.Builder getExportJobRequest() {
            return this.exportJobRequest != null ? this.exportJobRequest.toBuilder() : null;
        }

        public final void setExportJobRequest(ExportJobRequest.BuilderImpl exportJobRequest) {
            this.exportJobRequest = exportJobRequest != null ? exportJobRequest.build() : null;
        }

        @Override
        @Transient
        public final Builder exportJobRequest(ExportJobRequest exportJobRequest) {
            this.exportJobRequest = exportJobRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportJobRequest build() {
            return new CreateExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExportJobRequest> {
        public Builder applicationId(String var1);

        public Builder exportJobRequest(ExportJobRequest var1);

        default public Builder exportJobRequest(Consumer<ExportJobRequest.Builder> exportJobRequest) {
            return this.exportJobRequest((ExportJobRequest)((ExportJobRequest.Builder)ExportJobRequest.builder().applyMutation(exportJobRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

