/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ButtonAction {
    LINK("LINK"),
    DEEP_LINK("DEEP_LINK"),
    CLOSE("CLOSE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ButtonAction> VALUE_MAP;
    private final String value;

    private ButtonAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ButtonAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ButtonAction> knownValues() {
        EnumSet<ButtonAction> knownValues = EnumSet.allOf(ButtonAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ButtonAction.class, ButtonAction::toString);
    }
}

