/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeliveryStatus {
    SUCCESSFUL("SUCCESSFUL"),
    THROTTLED("THROTTLED"),
    TEMPORARY_FAILURE("TEMPORARY_FAILURE"),
    PERMANENT_FAILURE("PERMANENT_FAILURE"),
    UNKNOWN_FAILURE("UNKNOWN_FAILURE"),
    OPT_OUT("OPT_OUT"),
    DUPLICATE("DUPLICATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeliveryStatus> VALUE_MAP;
    private final String value;

    private DeliveryStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryStatus> knownValues() {
        EnumSet<DeliveryStatus> knownValues = EnumSet.allOf(DeliveryStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeliveryStatus.class, DeliveryStatus::toString);
    }
}

