/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecommenderConfigurationRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateRecommenderConfigurationRequest> {
    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderId").getter(UpdateRecommenderConfigurationRequest.getter(UpdateRecommenderConfigurationRequest::recommenderId)).setter(UpdateRecommenderConfigurationRequest.setter(Builder::recommenderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("recommender-id").build()}).build();
    private static final SdkField<UpdateRecommenderConfiguration> UPDATE_RECOMMENDER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UpdateRecommenderConfiguration").getter(UpdateRecommenderConfigurationRequest.getter(UpdateRecommenderConfigurationRequest::updateRecommenderConfiguration)).setter(UpdateRecommenderConfigurationRequest.setter(Builder::updateRecommenderConfiguration)).constructor(UpdateRecommenderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateRecommenderConfiguration").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_ID_FIELD, UPDATE_RECOMMENDER_CONFIGURATION_FIELD));
    private final String recommenderId;
    private final UpdateRecommenderConfiguration updateRecommenderConfiguration;

    private UpdateRecommenderConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.recommenderId = builder.recommenderId;
        this.updateRecommenderConfiguration = builder.updateRecommenderConfiguration;
    }

    public final String recommenderId() {
        return this.recommenderId;
    }

    public final UpdateRecommenderConfiguration updateRecommenderConfiguration() {
        return this.updateRecommenderConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateRecommenderConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecommenderConfigurationRequest)) {
            return false;
        }
        UpdateRecommenderConfigurationRequest other = (UpdateRecommenderConfigurationRequest)((Object)obj);
        return Objects.equals(this.recommenderId(), other.recommenderId()) && Objects.equals(this.updateRecommenderConfiguration(), other.updateRecommenderConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecommenderConfigurationRequest").add("RecommenderId", (Object)this.recommenderId()).add("UpdateRecommenderConfiguration", (Object)this.updateRecommenderConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommenderId": {
                return Optional.ofNullable(clazz.cast(this.recommenderId()));
            }
            case "UpdateRecommenderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.updateRecommenderConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecommenderConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateRecommenderConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String recommenderId;
        private UpdateRecommenderConfiguration updateRecommenderConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecommenderConfigurationRequest model) {
            super(model);
            this.recommenderId(model.recommenderId);
            this.updateRecommenderConfiguration(model.updateRecommenderConfiguration);
        }

        public final String getRecommenderId() {
            return this.recommenderId;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final UpdateRecommenderConfiguration.Builder getUpdateRecommenderConfiguration() {
            return this.updateRecommenderConfiguration != null ? this.updateRecommenderConfiguration.toBuilder() : null;
        }

        public final void setUpdateRecommenderConfiguration(UpdateRecommenderConfiguration.BuilderImpl updateRecommenderConfiguration) {
            this.updateRecommenderConfiguration = updateRecommenderConfiguration != null ? updateRecommenderConfiguration.build() : null;
        }

        @Override
        public final Builder updateRecommenderConfiguration(UpdateRecommenderConfiguration updateRecommenderConfiguration) {
            this.updateRecommenderConfiguration = updateRecommenderConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecommenderConfigurationRequest build() {
            return new UpdateRecommenderConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecommenderConfigurationRequest> {
        public Builder recommenderId(String var1);

        public Builder updateRecommenderConfiguration(UpdateRecommenderConfiguration var1);

        default public Builder updateRecommenderConfiguration(Consumer<UpdateRecommenderConfiguration.Builder> updateRecommenderConfiguration) {
            return this.updateRecommenderConfiguration((UpdateRecommenderConfiguration)((UpdateRecommenderConfiguration.Builder)UpdateRecommenderConfiguration.builder().applyMutation(updateRecommenderConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

