/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.AttributeDimension;
import software.amazon.awssdk.services.pinpoint.model.MapOfAttributeDimensionCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOfMetricDimensionCopier;
import software.amazon.awssdk.services.pinpoint.model.MetricDimension;
import software.amazon.awssdk.services.pinpoint.model.SegmentBehaviors;
import software.amazon.awssdk.services.pinpoint.model.SegmentDemographics;
import software.amazon.awssdk.services.pinpoint.model.SegmentLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentDimensions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentDimensions> {
    private static final SdkField<Map<String, AttributeDimension>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(SegmentDimensions.getter(SegmentDimensions::attributes)).setter(SegmentDimensions.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SegmentBehaviors> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Behavior").getter(SegmentDimensions.getter(SegmentDimensions::behavior)).setter(SegmentDimensions.setter(Builder::behavior)).constructor(SegmentBehaviors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Behavior").build()}).build();
    private static final SdkField<SegmentDemographics> DEMOGRAPHIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Demographic").getter(SegmentDimensions.getter(SegmentDimensions::demographic)).setter(SegmentDimensions.setter(Builder::demographic)).constructor(SegmentDemographics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Demographic").build()}).build();
    private static final SdkField<SegmentLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Location").getter(SegmentDimensions.getter(SegmentDimensions::location)).setter(SegmentDimensions.setter(Builder::location)).constructor(SegmentLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<Map<String, MetricDimension>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metrics").getter(SegmentDimensions.getter(SegmentDimensions::metrics)).setter(SegmentDimensions.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeDimension>> USER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserAttributes").getter(SegmentDimensions.getter(SegmentDimensions::userAttributes)).setter(SegmentDimensions.setter(Builder::userAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, BEHAVIOR_FIELD, DEMOGRAPHIC_FIELD, LOCATION_FIELD, METRICS_FIELD, USER_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeDimension> attributes;
    private final SegmentBehaviors behavior;
    private final SegmentDemographics demographic;
    private final SegmentLocation location;
    private final Map<String, MetricDimension> metrics;
    private final Map<String, AttributeDimension> userAttributes;

    private SegmentDimensions(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.behavior = builder.behavior;
        this.demographic = builder.demographic;
        this.location = builder.location;
        this.metrics = builder.metrics;
        this.userAttributes = builder.userAttributes;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeDimension> attributes() {
        return this.attributes;
    }

    public final SegmentBehaviors behavior() {
        return this.behavior;
    }

    public final SegmentDemographics demographic() {
        return this.demographic;
    }

    public final SegmentLocation location() {
        return this.location;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, MetricDimension> metrics() {
        return this.metrics;
    }

    public final boolean hasUserAttributes() {
        return this.userAttributes != null && !(this.userAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeDimension> userAttributes() {
        return this.userAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.behavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.demographic());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAttributes() ? this.userAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDimensions)) {
            return false;
        }
        SegmentDimensions other = (SegmentDimensions)obj;
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.behavior(), other.behavior()) && Objects.equals(this.demographic(), other.demographic()) && Objects.equals(this.location(), other.location()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && this.hasUserAttributes() == other.hasUserAttributes() && Objects.equals(this.userAttributes(), other.userAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentDimensions").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Behavior", (Object)this.behavior()).add("Demographic", (Object)this.demographic()).add("Location", (Object)this.location()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("UserAttributes", this.hasUserAttributes() ? this.userAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Behavior": {
                return Optional.ofNullable(clazz.cast(this.behavior()));
            }
            case "Demographic": {
                return Optional.ofNullable(clazz.cast(this.demographic()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "UserAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentDimensions, T> g) {
        return obj -> g.apply((SegmentDimensions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeDimension> attributes = DefaultSdkAutoConstructMap.getInstance();
        private SegmentBehaviors behavior;
        private SegmentDemographics demographic;
        private SegmentLocation location;
        private Map<String, MetricDimension> metrics = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeDimension> userAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDimensions model) {
            this.attributes(model.attributes);
            this.behavior(model.behavior);
            this.demographic(model.demographic);
            this.location(model.location);
            this.metrics(model.metrics);
            this.userAttributes(model.userAttributes);
        }

        public final Map<String, AttributeDimension.Builder> getAttributes() {
            Map<String, AttributeDimension.Builder> result = MapOfAttributeDimensionCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Map<String, AttributeDimension.BuilderImpl> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Map<String, AttributeDimension> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copy(attributes);
            return this;
        }

        public final SegmentBehaviors.Builder getBehavior() {
            return this.behavior != null ? this.behavior.toBuilder() : null;
        }

        public final void setBehavior(SegmentBehaviors.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        @Override
        @Transient
        public final Builder behavior(SegmentBehaviors behavior) {
            this.behavior = behavior;
            return this;
        }

        public final SegmentDemographics.Builder getDemographic() {
            return this.demographic != null ? this.demographic.toBuilder() : null;
        }

        public final void setDemographic(SegmentDemographics.BuilderImpl demographic) {
            this.demographic = demographic != null ? demographic.build() : null;
        }

        @Override
        @Transient
        public final Builder demographic(SegmentDemographics demographic) {
            this.demographic = demographic;
            return this;
        }

        public final SegmentLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(SegmentLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(SegmentLocation location) {
            this.location = location;
            return this;
        }

        public final Map<String, MetricDimension.Builder> getMetrics() {
            Map<String, MetricDimension.Builder> result = MapOfMetricDimensionCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Map<String, MetricDimension.BuilderImpl> metrics) {
            this.metrics = MapOfMetricDimensionCopier.copyFromBuilder(metrics);
        }

        @Override
        @Transient
        public final Builder metrics(Map<String, MetricDimension> metrics) {
            this.metrics = MapOfMetricDimensionCopier.copy(metrics);
            return this;
        }

        public final Map<String, AttributeDimension.Builder> getUserAttributes() {
            Map<String, AttributeDimension.Builder> result = MapOfAttributeDimensionCopier.copyToBuilder(this.userAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUserAttributes(Map<String, AttributeDimension.BuilderImpl> userAttributes) {
            this.userAttributes = MapOfAttributeDimensionCopier.copyFromBuilder(userAttributes);
        }

        @Override
        @Transient
        public final Builder userAttributes(Map<String, AttributeDimension> userAttributes) {
            this.userAttributes = MapOfAttributeDimensionCopier.copy(userAttributes);
            return this;
        }

        public SegmentDimensions build() {
            return new SegmentDimensions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentDimensions> {
        public Builder attributes(Map<String, AttributeDimension> var1);

        public Builder behavior(SegmentBehaviors var1);

        default public Builder behavior(Consumer<SegmentBehaviors.Builder> behavior) {
            return this.behavior((SegmentBehaviors)((SegmentBehaviors.Builder)SegmentBehaviors.builder().applyMutation(behavior)).build());
        }

        public Builder demographic(SegmentDemographics var1);

        default public Builder demographic(Consumer<SegmentDemographics.Builder> demographic) {
            return this.demographic((SegmentDemographics)((SegmentDemographics.Builder)SegmentDemographics.builder().applyMutation(demographic)).build());
        }

        public Builder location(SegmentLocation var1);

        default public Builder location(Consumer<SegmentLocation.Builder> location) {
            return this.location((SegmentLocation)((SegmentLocation.Builder)SegmentLocation.builder().applyMutation(location)).build());
        }

        public Builder metrics(Map<String, MetricDimension> var1);

        public Builder userAttributes(Map<String, AttributeDimension> var1);
    }
}

