/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.ButtonAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OverrideButtonConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OverrideButtonConfiguration> {
    private static final SdkField<String> BUTTON_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ButtonAction").getter(OverrideButtonConfiguration.getter(OverrideButtonConfiguration::buttonActionAsString)).setter(OverrideButtonConfiguration.setter(Builder::buttonAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ButtonAction").build()}).build();
    private static final SdkField<String> LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Link").getter(OverrideButtonConfiguration.getter(OverrideButtonConfiguration::link)).setter(OverrideButtonConfiguration.setter(Builder::link)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Link").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUTTON_ACTION_FIELD, LINK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String buttonAction;
    private final String link;

    private OverrideButtonConfiguration(BuilderImpl builder) {
        this.buttonAction = builder.buttonAction;
        this.link = builder.link;
    }

    public final ButtonAction buttonAction() {
        return ButtonAction.fromValue(this.buttonAction);
    }

    public final String buttonActionAsString() {
        return this.buttonAction;
    }

    public final String link() {
        return this.link;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.buttonActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.link());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverrideButtonConfiguration)) {
            return false;
        }
        OverrideButtonConfiguration other = (OverrideButtonConfiguration)obj;
        return Objects.equals(this.buttonActionAsString(), other.buttonActionAsString()) && Objects.equals(this.link(), other.link());
    }

    public final String toString() {
        return ToString.builder((String)"OverrideButtonConfiguration").add("ButtonAction", (Object)this.buttonActionAsString()).add("Link", (Object)this.link()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ButtonAction": {
                return Optional.ofNullable(clazz.cast(this.buttonActionAsString()));
            }
            case "Link": {
                return Optional.ofNullable(clazz.cast(this.link()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OverrideButtonConfiguration, T> g) {
        return obj -> g.apply((OverrideButtonConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String buttonAction;
        private String link;

        private BuilderImpl() {
        }

        private BuilderImpl(OverrideButtonConfiguration model) {
            this.buttonAction(model.buttonAction);
            this.link(model.link);
        }

        public final String getButtonAction() {
            return this.buttonAction;
        }

        public final void setButtonAction(String buttonAction) {
            this.buttonAction = buttonAction;
        }

        @Override
        @Transient
        public final Builder buttonAction(String buttonAction) {
            this.buttonAction = buttonAction;
            return this;
        }

        @Override
        @Transient
        public final Builder buttonAction(ButtonAction buttonAction) {
            this.buttonAction(buttonAction == null ? null : buttonAction.toString());
            return this;
        }

        public final String getLink() {
            return this.link;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        @Override
        @Transient
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        public OverrideButtonConfiguration build() {
            return new OverrideButtonConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OverrideButtonConfiguration> {
        public Builder buttonAction(String var1);

        public Builder buttonAction(ButtonAction var1);

        public Builder link(String var1);
    }
}

