/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JourneyLimits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JourneyLimits> {
    private static final SdkField<Integer> DAILY_CAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DailyCap").getter(JourneyLimits.getter(JourneyLimits::dailyCap)).setter(JourneyLimits.setter(Builder::dailyCap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyCap").build()}).build();
    private static final SdkField<Integer> ENDPOINT_REENTRY_CAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndpointReentryCap").getter(JourneyLimits.getter(JourneyLimits::endpointReentryCap)).setter(JourneyLimits.setter(Builder::endpointReentryCap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointReentryCap").build()}).build();
    private static final SdkField<Integer> MESSAGES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MessagesPerSecond").getter(JourneyLimits.getter(JourneyLimits::messagesPerSecond)).setter(JourneyLimits.setter(Builder::messagesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagesPerSecond").build()}).build();
    private static final SdkField<String> ENDPOINT_REENTRY_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointReentryInterval").getter(JourneyLimits.getter(JourneyLimits::endpointReentryInterval)).setter(JourneyLimits.setter(Builder::endpointReentryInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointReentryInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_CAP_FIELD, ENDPOINT_REENTRY_CAP_FIELD, MESSAGES_PER_SECOND_FIELD, ENDPOINT_REENTRY_INTERVAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer dailyCap;
    private final Integer endpointReentryCap;
    private final Integer messagesPerSecond;
    private final String endpointReentryInterval;

    private JourneyLimits(BuilderImpl builder) {
        this.dailyCap = builder.dailyCap;
        this.endpointReentryCap = builder.endpointReentryCap;
        this.messagesPerSecond = builder.messagesPerSecond;
        this.endpointReentryInterval = builder.endpointReentryInterval;
    }

    public final Integer dailyCap() {
        return this.dailyCap;
    }

    public final Integer endpointReentryCap() {
        return this.endpointReentryCap;
    }

    public final Integer messagesPerSecond() {
        return this.messagesPerSecond;
    }

    public final String endpointReentryInterval() {
        return this.endpointReentryInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyCap());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointReentryCap());
        hashCode = 31 * hashCode + Objects.hashCode(this.messagesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointReentryInterval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyLimits)) {
            return false;
        }
        JourneyLimits other = (JourneyLimits)obj;
        return Objects.equals(this.dailyCap(), other.dailyCap()) && Objects.equals(this.endpointReentryCap(), other.endpointReentryCap()) && Objects.equals(this.messagesPerSecond(), other.messagesPerSecond()) && Objects.equals(this.endpointReentryInterval(), other.endpointReentryInterval());
    }

    public final String toString() {
        return ToString.builder((String)"JourneyLimits").add("DailyCap", (Object)this.dailyCap()).add("EndpointReentryCap", (Object)this.endpointReentryCap()).add("MessagesPerSecond", (Object)this.messagesPerSecond()).add("EndpointReentryInterval", (Object)this.endpointReentryInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DailyCap": {
                return Optional.ofNullable(clazz.cast(this.dailyCap()));
            }
            case "EndpointReentryCap": {
                return Optional.ofNullable(clazz.cast(this.endpointReentryCap()));
            }
            case "MessagesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.messagesPerSecond()));
            }
            case "EndpointReentryInterval": {
                return Optional.ofNullable(clazz.cast(this.endpointReentryInterval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyLimits, T> g) {
        return obj -> g.apply((JourneyLimits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dailyCap;
        private Integer endpointReentryCap;
        private Integer messagesPerSecond;
        private String endpointReentryInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyLimits model) {
            this.dailyCap(model.dailyCap);
            this.endpointReentryCap(model.endpointReentryCap);
            this.messagesPerSecond(model.messagesPerSecond);
            this.endpointReentryInterval(model.endpointReentryInterval);
        }

        public final Integer getDailyCap() {
            return this.dailyCap;
        }

        public final void setDailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
        }

        @Override
        @Transient
        public final Builder dailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
            return this;
        }

        public final Integer getEndpointReentryCap() {
            return this.endpointReentryCap;
        }

        public final void setEndpointReentryCap(Integer endpointReentryCap) {
            this.endpointReentryCap = endpointReentryCap;
        }

        @Override
        @Transient
        public final Builder endpointReentryCap(Integer endpointReentryCap) {
            this.endpointReentryCap = endpointReentryCap;
            return this;
        }

        public final Integer getMessagesPerSecond() {
            return this.messagesPerSecond;
        }

        public final void setMessagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
        }

        @Override
        @Transient
        public final Builder messagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
            return this;
        }

        public final String getEndpointReentryInterval() {
            return this.endpointReentryInterval;
        }

        public final void setEndpointReentryInterval(String endpointReentryInterval) {
            this.endpointReentryInterval = endpointReentryInterval;
        }

        @Override
        @Transient
        public final Builder endpointReentryInterval(String endpointReentryInterval) {
            this.endpointReentryInterval = endpointReentryInterval;
            return this;
        }

        public JourneyLimits build() {
            return new JourneyLimits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JourneyLimits> {
        public Builder dailyCap(Integer var1);

        public Builder endpointReentryCap(Integer var1);

        public Builder messagesPerSecond(Integer var1);

        public Builder endpointReentryInterval(String var1);
    }
}

