/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributesResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributesResource> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(AttributesResource.getter(AttributesResource::applicationId)).setter(AttributesResource.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeType").getter(AttributesResource.getter(AttributesResource::attributeType)).setter(AttributesResource.setter(Builder::attributeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeType").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(AttributesResource.getter(AttributesResource::attributes)).setter(AttributesResource.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ATTRIBUTE_TYPE_FIELD, ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String attributeType;
    private final List<String> attributes;

    private AttributesResource(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.attributeType = builder.attributeType;
        this.attributes = builder.attributes;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String attributeType() {
        return this.attributeType;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributesResource)) {
            return false;
        }
        AttributesResource other = (AttributesResource)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.attributeType(), other.attributeType()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"AttributesResource").add("ApplicationId", (Object)this.applicationId()).add("AttributeType", (Object)this.attributeType()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "AttributeType": {
                return Optional.ofNullable(clazz.cast(this.attributeType()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributesResource, T> g) {
        return obj -> g.apply((AttributesResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String attributeType;
        private List<String> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributesResource model) {
            this.applicationId(model.applicationId);
            this.attributeType(model.attributeType);
            this.attributes(model.attributes);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getAttributeType() {
            return this.attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public final Collection<String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<String> attributes) {
            this.attributes = ListOf__stringCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(String ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<String> attributes) {
            this.attributes = ListOf__stringCopier.copy(attributes);
        }

        public AttributesResource build() {
            return new AttributesResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributesResource> {
        public Builder applicationId(String var1);

        public Builder attributeType(String var1);

        public Builder attributes(Collection<String> var1);

        public Builder attributes(String ... var1);
    }
}

