/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultPushNotificationMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultPushNotificationMessage> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(DefaultPushNotificationMessage.getter(DefaultPushNotificationMessage::actionAsString)).setter(DefaultPushNotificationMessage.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(DefaultPushNotificationMessage.getter(DefaultPushNotificationMessage::body)).setter(DefaultPushNotificationMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Data").getter(DefaultPushNotificationMessage.getter(DefaultPushNotificationMessage::data)).setter(DefaultPushNotificationMessage.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SilentPush").getter(DefaultPushNotificationMessage.getter(DefaultPushNotificationMessage::silentPush)).setter(DefaultPushNotificationMessage.setter(Builder::silentPush)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()}).build();
    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Substitutions").getter(DefaultPushNotificationMessage.getter(DefaultPushNotificationMessage::substitutions)).setter(DefaultPushNotificationMessage.setter(Builder::substitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(DefaultPushNotificationMessage.getter(DefaultPushNotificationMessage::title)).setter(DefaultPushNotificationMessage.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(DefaultPushNotificationMessage.getter(DefaultPushNotificationMessage::url)).setter(DefaultPushNotificationMessage.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD, DATA_FIELD, SILENT_PUSH_FIELD, SUBSTITUTIONS_FIELD, TITLE_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String body;
    private final Map<String, String> data;
    private final Boolean silentPush;
    private final Map<String, List<String>> substitutions;
    private final String title;
    private final String url;

    private DefaultPushNotificationMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.data = builder.data;
        this.silentPush = builder.silentPush;
        this.substitutions = builder.substitutions;
        this.title = builder.title;
        this.url = builder.url;
    }

    public final Action action() {
        return Action.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String body() {
        return this.body;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> data() {
        return this.data;
    }

    public final Boolean silentPush() {
        return this.silentPush;
    }

    public final boolean hasSubstitutions() {
        return this.substitutions != null && !(this.substitutions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public final String title() {
        return this.title;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubstitutions() ? this.substitutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPushNotificationMessage)) {
            return false;
        }
        DefaultPushNotificationMessage other = (DefaultPushNotificationMessage)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.body(), other.body()) && this.hasData() == other.hasData() && Objects.equals(this.data(), other.data()) && Objects.equals(this.silentPush(), other.silentPush()) && this.hasSubstitutions() == other.hasSubstitutions() && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultPushNotificationMessage").add("Action", (Object)this.actionAsString()).add("Body", (Object)this.body()).add("Data", this.hasData() ? this.data() : null).add("SilentPush", (Object)this.silentPush()).add("Substitutions", this.hasSubstitutions() ? this.substitutions() : null).add("Title", (Object)this.title()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "SilentPush": {
                return Optional.ofNullable(clazz.cast(this.silentPush()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultPushNotificationMessage, T> g) {
        return obj -> g.apply((DefaultPushNotificationMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String body;
        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();
        private Boolean silentPush;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultPushNotificationMessage model) {
            this.action(model.action);
            this.body(model.body);
            this.data(model.data);
            this.silentPush(model.silentPush);
            this.substitutions(model.substitutions);
            this.title(model.title);
            this.url(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getData() {
            if (this.data instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (this.substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public DefaultPushNotificationMessage build() {
            return new DefaultPushNotificationMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultPushNotificationMessage> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder body(String var1);

        public Builder data(Map<String, String> var1);

        public Builder silentPush(Boolean var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

