/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGcmChannelRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateGcmChannelRequest.Builder, UpdateGcmChannelRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(UpdateGcmChannelRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<GCMChannelRequest> GCM_CHANNEL_REQUEST_FIELD = SdkField
            .<GCMChannelRequest> builder(MarshallingType.SDK_POJO)
            .memberName("GCMChannelRequest")
            .getter(getter(UpdateGcmChannelRequest::gcmChannelRequest))
            .setter(setter(Builder::gcmChannelRequest))
            .constructor(GCMChannelRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCMChannelRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            GCM_CHANNEL_REQUEST_FIELD));

    private final String applicationId;

    private final GCMChannelRequest gcmChannelRequest;

    private UpdateGcmChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.gcmChannelRequest = builder.gcmChannelRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the GCMChannelRequest property for this object.
     * 
     * @return The value of the GCMChannelRequest property for this object.
     */
    public final GCMChannelRequest gcmChannelRequest() {
        return gcmChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(gcmChannelRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGcmChannelRequest)) {
            return false;
        }
        UpdateGcmChannelRequest other = (UpdateGcmChannelRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(gcmChannelRequest(), other.gcmChannelRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGcmChannelRequest").add("ApplicationId", applicationId())
                .add("GCMChannelRequest", gcmChannelRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "GCMChannelRequest":
            return Optional.ofNullable(clazz.cast(gcmChannelRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGcmChannelRequest, T> g) {
        return obj -> g.apply((UpdateGcmChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGcmChannelRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the GCMChannelRequest property for this object.
         *
         * @param gcmChannelRequest
         *        The new value for the GCMChannelRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcmChannelRequest(GCMChannelRequest gcmChannelRequest);

        /**
         * Sets the value of the GCMChannelRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link GCMChannelRequest.Builder} avoiding the need to
         * create one manually via {@link GCMChannelRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link GCMChannelRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #gcmChannelRequest(GCMChannelRequest)}.
         * 
         * @param gcmChannelRequest
         *        a consumer that will call methods on {@link GCMChannelRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gcmChannelRequest(GCMChannelRequest)
         */
        default Builder gcmChannelRequest(Consumer<GCMChannelRequest.Builder> gcmChannelRequest) {
            return gcmChannelRequest(GCMChannelRequest.builder().applyMutation(gcmChannelRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private GCMChannelRequest gcmChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGcmChannelRequest model) {
            super(model);
            applicationId(model.applicationId);
            gcmChannelRequest(model.gcmChannelRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final GCMChannelRequest.Builder getGcmChannelRequest() {
            return gcmChannelRequest != null ? gcmChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder gcmChannelRequest(GCMChannelRequest gcmChannelRequest) {
            this.gcmChannelRequest = gcmChannelRequest;
            return this;
        }

        public final void setGcmChannelRequest(GCMChannelRequest.BuilderImpl gcmChannelRequest) {
            this.gcmChannelRequest = gcmChannelRequest != null ? gcmChannelRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGcmChannelRequest build() {
            return new UpdateGcmChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
