/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.BaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBaiduChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateBaiduChannelRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateBaiduChannelRequest.getter(UpdateBaiduChannelRequest::applicationId)).setter(UpdateBaiduChannelRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<BaiduChannelRequest> BAIDU_CHANNEL_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BaiduChannelRequest").getter(UpdateBaiduChannelRequest.getter(UpdateBaiduChannelRequest::baiduChannelRequest)).setter(UpdateBaiduChannelRequest.setter(Builder::baiduChannelRequest)).constructor(BaiduChannelRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaiduChannelRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, BAIDU_CHANNEL_REQUEST_FIELD));
    private final String applicationId;
    private final BaiduChannelRequest baiduChannelRequest;

    private UpdateBaiduChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.baiduChannelRequest = builder.baiduChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public BaiduChannelRequest baiduChannelRequest() {
        return this.baiduChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baiduChannelRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBaiduChannelRequest)) {
            return false;
        }
        UpdateBaiduChannelRequest other = (UpdateBaiduChannelRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.baiduChannelRequest(), other.baiduChannelRequest());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBaiduChannelRequest").add("ApplicationId", (Object)this.applicationId()).add("BaiduChannelRequest", (Object)this.baiduChannelRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "BaiduChannelRequest": {
                return Optional.ofNullable(clazz.cast(this.baiduChannelRequest()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBaiduChannelRequest, T> g) {
        return obj -> g.apply((UpdateBaiduChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private BaiduChannelRequest baiduChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBaiduChannelRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.baiduChannelRequest(model.baiduChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final BaiduChannelRequest.Builder getBaiduChannelRequest() {
            return this.baiduChannelRequest != null ? this.baiduChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder baiduChannelRequest(BaiduChannelRequest baiduChannelRequest) {
            this.baiduChannelRequest = baiduChannelRequest;
            return this;
        }

        public final void setBaiduChannelRequest(BaiduChannelRequest.BuilderImpl baiduChannelRequest) {
            this.baiduChannelRequest = baiduChannelRequest != null ? baiduChannelRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBaiduChannelRequest build() {
            return new UpdateBaiduChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBaiduChannelRequest> {
        public Builder applicationId(String var1);

        public Builder baiduChannelRequest(BaiduChannelRequest var1);

        default public Builder baiduChannelRequest(Consumer<BaiduChannelRequest.Builder> baiduChannelRequest) {
            return this.baiduChannelRequest((BaiduChannelRequest)((BaiduChannelRequest.Builder)BaiduChannelRequest.builder().applyMutation(baiduChannelRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

