/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class APNSMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, APNSMessage> {
    private static final SdkField<String> APNS_PUSH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("APNSPushType").getter(APNSMessage.getter(APNSMessage::apnsPushType)).setter(APNSMessage.setter(Builder::apnsPushType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSPushType").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(APNSMessage.getter(APNSMessage::actionAsString)).setter(APNSMessage.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<Integer> BADGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Badge").getter(APNSMessage.getter(APNSMessage::badge)).setter(APNSMessage.setter(Builder::badge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Badge").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(APNSMessage.getter(APNSMessage::body)).setter(APNSMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(APNSMessage.getter(APNSMessage::category)).setter(APNSMessage.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> COLLAPSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollapseId").getter(APNSMessage.getter(APNSMessage::collapseId)).setter(APNSMessage.setter(Builder::collapseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollapseId").build()}).build();
    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Data").getter(APNSMessage.getter(APNSMessage::data)).setter(APNSMessage.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaUrl").getter(APNSMessage.getter(APNSMessage::mediaUrl)).setter(APNSMessage.setter(Builder::mediaUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrl").build()}).build();
    private static final SdkField<String> PREFERRED_AUTHENTICATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredAuthenticationMethod").getter(APNSMessage.getter(APNSMessage::preferredAuthenticationMethod)).setter(APNSMessage.setter(Builder::preferredAuthenticationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAuthenticationMethod").build()}).build();
    private static final SdkField<String> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Priority").getter(APNSMessage.getter(APNSMessage::priority)).setter(APNSMessage.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RawContent").getter(APNSMessage.getter(APNSMessage::rawContent)).setter(APNSMessage.setter(Builder::rawContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()}).build();
    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SilentPush").getter(APNSMessage.getter(APNSMessage::silentPush)).setter(APNSMessage.setter(Builder::silentPush)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()}).build();
    private static final SdkField<String> SOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sound").getter(APNSMessage.getter(APNSMessage::sound)).setter(APNSMessage.setter(Builder::sound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sound").build()}).build();
    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Substitutions").getter(APNSMessage.getter(APNSMessage::substitutions)).setter(APNSMessage.setter(Builder::substitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> THREAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThreadId").getter(APNSMessage.getter(APNSMessage::threadId)).setter(APNSMessage.setter(Builder::threadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadId").build()}).build();
    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeToLive").getter(APNSMessage.getter(APNSMessage::timeToLive)).setter(APNSMessage.setter(Builder::timeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(APNSMessage.getter(APNSMessage::title)).setter(APNSMessage.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(APNSMessage.getter(APNSMessage::url)).setter(APNSMessage.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APNS_PUSH_TYPE_FIELD, ACTION_FIELD, BADGE_FIELD, BODY_FIELD, CATEGORY_FIELD, COLLAPSE_ID_FIELD, DATA_FIELD, MEDIA_URL_FIELD, PREFERRED_AUTHENTICATION_METHOD_FIELD, PRIORITY_FIELD, RAW_CONTENT_FIELD, SILENT_PUSH_FIELD, SOUND_FIELD, SUBSTITUTIONS_FIELD, THREAD_ID_FIELD, TIME_TO_LIVE_FIELD, TITLE_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apnsPushType;
    private final String action;
    private final Integer badge;
    private final String body;
    private final String category;
    private final String collapseId;
    private final Map<String, String> data;
    private final String mediaUrl;
    private final String preferredAuthenticationMethod;
    private final String priority;
    private final String rawContent;
    private final Boolean silentPush;
    private final String sound;
    private final Map<String, List<String>> substitutions;
    private final String threadId;
    private final Integer timeToLive;
    private final String title;
    private final String url;

    private APNSMessage(BuilderImpl builder) {
        this.apnsPushType = builder.apnsPushType;
        this.action = builder.action;
        this.badge = builder.badge;
        this.body = builder.body;
        this.category = builder.category;
        this.collapseId = builder.collapseId;
        this.data = builder.data;
        this.mediaUrl = builder.mediaUrl;
        this.preferredAuthenticationMethod = builder.preferredAuthenticationMethod;
        this.priority = builder.priority;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.sound = builder.sound;
        this.substitutions = builder.substitutions;
        this.threadId = builder.threadId;
        this.timeToLive = builder.timeToLive;
        this.title = builder.title;
        this.url = builder.url;
    }

    public String apnsPushType() {
        return this.apnsPushType;
    }

    public Action action() {
        return Action.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public Integer badge() {
        return this.badge;
    }

    public String body() {
        return this.body;
    }

    public String category() {
        return this.category;
    }

    public String collapseId() {
        return this.collapseId;
    }

    public boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructMap);
    }

    public Map<String, String> data() {
        return this.data;
    }

    public String mediaUrl() {
        return this.mediaUrl;
    }

    public String preferredAuthenticationMethod() {
        return this.preferredAuthenticationMethod;
    }

    public String priority() {
        return this.priority;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public Boolean silentPush() {
        return this.silentPush;
    }

    public String sound() {
        return this.sound;
    }

    public boolean hasSubstitutions() {
        return this.substitutions != null && !(this.substitutions instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String threadId() {
        return this.threadId;
    }

    public Integer timeToLive() {
        return this.timeToLive;
    }

    public String title() {
        return this.title;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apnsPushType());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.badge());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.collapseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAuthenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(this.sound());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubstitutions() ? this.substitutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.threadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSMessage)) {
            return false;
        }
        APNSMessage other = (APNSMessage)obj;
        return Objects.equals(this.apnsPushType(), other.apnsPushType()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.badge(), other.badge()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.collapseId(), other.collapseId()) && this.hasData() == other.hasData() && Objects.equals(this.data(), other.data()) && Objects.equals(this.mediaUrl(), other.mediaUrl()) && Objects.equals(this.preferredAuthenticationMethod(), other.preferredAuthenticationMethod()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.silentPush(), other.silentPush()) && Objects.equals(this.sound(), other.sound()) && this.hasSubstitutions() == other.hasSubstitutions() && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.threadId(), other.threadId()) && Objects.equals(this.timeToLive(), other.timeToLive()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"APNSMessage").add("APNSPushType", (Object)this.apnsPushType()).add("Action", (Object)this.actionAsString()).add("Badge", (Object)this.badge()).add("Body", (Object)this.body()).add("Category", (Object)this.category()).add("CollapseId", (Object)this.collapseId()).add("Data", this.hasData() ? this.data() : null).add("MediaUrl", (Object)this.mediaUrl()).add("PreferredAuthenticationMethod", (Object)this.preferredAuthenticationMethod()).add("Priority", (Object)this.priority()).add("RawContent", (Object)this.rawContent()).add("SilentPush", (Object)this.silentPush()).add("Sound", (Object)this.sound()).add("Substitutions", this.hasSubstitutions() ? this.substitutions() : null).add("ThreadId", (Object)this.threadId()).add("TimeToLive", (Object)this.timeToLive()).add("Title", (Object)this.title()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "APNSPushType": {
                return Optional.ofNullable(clazz.cast(this.apnsPushType()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Badge": {
                return Optional.ofNullable(clazz.cast(this.badge()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "CollapseId": {
                return Optional.ofNullable(clazz.cast(this.collapseId()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "MediaUrl": {
                return Optional.ofNullable(clazz.cast(this.mediaUrl()));
            }
            case "PreferredAuthenticationMethod": {
                return Optional.ofNullable(clazz.cast(this.preferredAuthenticationMethod()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RawContent": {
                return Optional.ofNullable(clazz.cast(this.rawContent()));
            }
            case "SilentPush": {
                return Optional.ofNullable(clazz.cast(this.silentPush()));
            }
            case "Sound": {
                return Optional.ofNullable(clazz.cast(this.sound()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
            case "ThreadId": {
                return Optional.ofNullable(clazz.cast(this.threadId()));
            }
            case "TimeToLive": {
                return Optional.ofNullable(clazz.cast(this.timeToLive()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<APNSMessage, T> g) {
        return obj -> g.apply((APNSMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apnsPushType;
        private String action;
        private Integer badge;
        private String body;
        private String category;
        private String collapseId;
        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();
        private String mediaUrl;
        private String preferredAuthenticationMethod;
        private String priority;
        private String rawContent;
        private Boolean silentPush;
        private String sound;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();
        private String threadId;
        private Integer timeToLive;
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSMessage model) {
            this.apnsPushType(model.apnsPushType);
            this.action(model.action);
            this.badge(model.badge);
            this.body(model.body);
            this.category(model.category);
            this.collapseId(model.collapseId);
            this.data(model.data);
            this.mediaUrl(model.mediaUrl);
            this.preferredAuthenticationMethod(model.preferredAuthenticationMethod);
            this.priority(model.priority);
            this.rawContent(model.rawContent);
            this.silentPush(model.silentPush);
            this.sound(model.sound);
            this.substitutions(model.substitutions);
            this.threadId(model.threadId);
            this.timeToLive(model.timeToLive);
            this.title(model.title);
            this.url(model.url);
        }

        public final String getApnsPushType() {
            return this.apnsPushType;
        }

        @Override
        public final Builder apnsPushType(String apnsPushType) {
            this.apnsPushType = apnsPushType;
            return this;
        }

        public final void setApnsPushType(String apnsPushType) {
            this.apnsPushType = apnsPushType;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getBadge() {
            return this.badge;
        }

        @Override
        public final Builder badge(Integer badge) {
            this.badge = badge;
            return this;
        }

        public final void setBadge(Integer badge) {
            this.badge = badge;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getCollapseId() {
            return this.collapseId;
        }

        @Override
        public final Builder collapseId(String collapseId) {
            this.collapseId = collapseId;
            return this;
        }

        public final void setCollapseId(String collapseId) {
            this.collapseId = collapseId;
        }

        public final Map<String, String> getData() {
            if (this.data instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final String getMediaUrl() {
            return this.mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        public final String getPreferredAuthenticationMethod() {
            return this.preferredAuthenticationMethod;
        }

        @Override
        public final Builder preferredAuthenticationMethod(String preferredAuthenticationMethod) {
            this.preferredAuthenticationMethod = preferredAuthenticationMethod;
            return this;
        }

        public final void setPreferredAuthenticationMethod(String preferredAuthenticationMethod) {
            this.preferredAuthenticationMethod = preferredAuthenticationMethod;
        }

        public final String getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final String getSound() {
            return this.sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (this.substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getThreadId() {
            return this.threadId;
        }

        @Override
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public final Integer getTimeToLive() {
            return this.timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public APNSMessage build() {
            return new APNSMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, APNSMessage> {
        public Builder apnsPushType(String var1);

        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder badge(Integer var1);

        public Builder body(String var1);

        public Builder category(String var1);

        public Builder collapseId(String var1);

        public Builder data(Map<String, String> var1);

        public Builder mediaUrl(String var1);

        public Builder preferredAuthenticationMethod(String var1);

        public Builder priority(String var1);

        public Builder rawContent(String var1);

        public Builder silentPush(Boolean var1);

        public Builder sound(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder threadId(String var1);

        public Builder timeToLive(Integer var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

