/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GCMMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GCMMessage> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::actionAsString)).setter(GCMMessage.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::body)).setter(GCMMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> COLLAPSE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::collapseKey)).setter(GCMMessage.setter(Builder::collapseKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollapseKey").build()}).build();
    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GCMMessage.getter(GCMMessage::data)).setter(GCMMessage.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ICON_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::iconReference)).setter(GCMMessage.setter(Builder::iconReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconReference").build()}).build();
    private static final SdkField<String> IMAGE_ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::imageIconUrl)).setter(GCMMessage.setter(Builder::imageIconUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIconUrl").build()}).build();
    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::imageUrl)).setter(GCMMessage.setter(Builder::imageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()}).build();
    private static final SdkField<String> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::priority)).setter(GCMMessage.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::rawContent)).setter(GCMMessage.setter(Builder::rawContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()}).build();
    private static final SdkField<String> RESTRICTED_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::restrictedPackageName)).setter(GCMMessage.setter(Builder::restrictedPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictedPackageName").build()}).build();
    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GCMMessage.getter(GCMMessage::silentPush)).setter(GCMMessage.setter(Builder::silentPush)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()}).build();
    private static final SdkField<String> SMALL_IMAGE_ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::smallImageIconUrl)).setter(GCMMessage.setter(Builder::smallImageIconUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallImageIconUrl").build()}).build();
    private static final SdkField<String> SOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::sound)).setter(GCMMessage.setter(Builder::sound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sound").build()}).build();
    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GCMMessage.getter(GCMMessage::substitutions)).setter(GCMMessage.setter(Builder::substitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GCMMessage.getter(GCMMessage::timeToLive)).setter(GCMMessage.setter(Builder::timeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::title)).setter(GCMMessage.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GCMMessage.getter(GCMMessage::url)).setter(GCMMessage.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD, COLLAPSE_KEY_FIELD, DATA_FIELD, ICON_REFERENCE_FIELD, IMAGE_ICON_URL_FIELD, IMAGE_URL_FIELD, PRIORITY_FIELD, RAW_CONTENT_FIELD, RESTRICTED_PACKAGE_NAME_FIELD, SILENT_PUSH_FIELD, SMALL_IMAGE_ICON_URL_FIELD, SOUND_FIELD, SUBSTITUTIONS_FIELD, TIME_TO_LIVE_FIELD, TITLE_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String body;
    private final String collapseKey;
    private final Map<String, String> data;
    private final String iconReference;
    private final String imageIconUrl;
    private final String imageUrl;
    private final String priority;
    private final String rawContent;
    private final String restrictedPackageName;
    private final Boolean silentPush;
    private final String smallImageIconUrl;
    private final String sound;
    private final Map<String, List<String>> substitutions;
    private final Integer timeToLive;
    private final String title;
    private final String url;

    private GCMMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.collapseKey = builder.collapseKey;
        this.data = builder.data;
        this.iconReference = builder.iconReference;
        this.imageIconUrl = builder.imageIconUrl;
        this.imageUrl = builder.imageUrl;
        this.priority = builder.priority;
        this.rawContent = builder.rawContent;
        this.restrictedPackageName = builder.restrictedPackageName;
        this.silentPush = builder.silentPush;
        this.smallImageIconUrl = builder.smallImageIconUrl;
        this.sound = builder.sound;
        this.substitutions = builder.substitutions;
        this.timeToLive = builder.timeToLive;
        this.title = builder.title;
        this.url = builder.url;
    }

    public Action action() {
        return Action.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public String body() {
        return this.body;
    }

    public String collapseKey() {
        return this.collapseKey;
    }

    public boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructMap);
    }

    public Map<String, String> data() {
        return this.data;
    }

    public String iconReference() {
        return this.iconReference;
    }

    public String imageIconUrl() {
        return this.imageIconUrl;
    }

    public String imageUrl() {
        return this.imageUrl;
    }

    public String priority() {
        return this.priority;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public String restrictedPackageName() {
        return this.restrictedPackageName;
    }

    public Boolean silentPush() {
        return this.silentPush;
    }

    public String smallImageIconUrl() {
        return this.smallImageIconUrl;
    }

    public String sound() {
        return this.sound;
    }

    public boolean hasSubstitutions() {
        return this.substitutions != null && !(this.substitutions instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public Integer timeToLive() {
        return this.timeToLive;
    }

    public String title() {
        return this.title;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.collapseKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictedPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallImageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sound());
        hashCode = 31 * hashCode + Objects.hashCode(this.substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GCMMessage)) {
            return false;
        }
        GCMMessage other = (GCMMessage)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.collapseKey(), other.collapseKey()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.iconReference(), other.iconReference()) && Objects.equals(this.imageIconUrl(), other.imageIconUrl()) && Objects.equals(this.imageUrl(), other.imageUrl()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.restrictedPackageName(), other.restrictedPackageName()) && Objects.equals(this.silentPush(), other.silentPush()) && Objects.equals(this.smallImageIconUrl(), other.smallImageIconUrl()) && Objects.equals(this.sound(), other.sound()) && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.timeToLive(), other.timeToLive()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"GCMMessage").add("Action", (Object)this.actionAsString()).add("Body", (Object)this.body()).add("CollapseKey", (Object)this.collapseKey()).add("Data", this.data()).add("IconReference", (Object)this.iconReference()).add("ImageIconUrl", (Object)this.imageIconUrl()).add("ImageUrl", (Object)this.imageUrl()).add("Priority", (Object)this.priority()).add("RawContent", (Object)this.rawContent()).add("RestrictedPackageName", (Object)this.restrictedPackageName()).add("SilentPush", (Object)this.silentPush()).add("SmallImageIconUrl", (Object)this.smallImageIconUrl()).add("Sound", (Object)this.sound()).add("Substitutions", this.substitutions()).add("TimeToLive", (Object)this.timeToLive()).add("Title", (Object)this.title()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "CollapseKey": {
                return Optional.ofNullable(clazz.cast(this.collapseKey()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "IconReference": {
                return Optional.ofNullable(clazz.cast(this.iconReference()));
            }
            case "ImageIconUrl": {
                return Optional.ofNullable(clazz.cast(this.imageIconUrl()));
            }
            case "ImageUrl": {
                return Optional.ofNullable(clazz.cast(this.imageUrl()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RawContent": {
                return Optional.ofNullable(clazz.cast(this.rawContent()));
            }
            case "RestrictedPackageName": {
                return Optional.ofNullable(clazz.cast(this.restrictedPackageName()));
            }
            case "SilentPush": {
                return Optional.ofNullable(clazz.cast(this.silentPush()));
            }
            case "SmallImageIconUrl": {
                return Optional.ofNullable(clazz.cast(this.smallImageIconUrl()));
            }
            case "Sound": {
                return Optional.ofNullable(clazz.cast(this.sound()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
            case "TimeToLive": {
                return Optional.ofNullable(clazz.cast(this.timeToLive()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GCMMessage, T> g) {
        return obj -> g.apply((GCMMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String body;
        private String collapseKey;
        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();
        private String iconReference;
        private String imageIconUrl;
        private String imageUrl;
        private String priority;
        private String rawContent;
        private String restrictedPackageName;
        private Boolean silentPush;
        private String smallImageIconUrl;
        private String sound;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();
        private Integer timeToLive;
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(GCMMessage model) {
            this.action(model.action);
            this.body(model.body);
            this.collapseKey(model.collapseKey);
            this.data(model.data);
            this.iconReference(model.iconReference);
            this.imageIconUrl(model.imageIconUrl);
            this.imageUrl(model.imageUrl);
            this.priority(model.priority);
            this.rawContent(model.rawContent);
            this.restrictedPackageName(model.restrictedPackageName);
            this.silentPush(model.silentPush);
            this.smallImageIconUrl(model.smallImageIconUrl);
            this.sound(model.sound);
            this.substitutions(model.substitutions);
            this.timeToLive(model.timeToLive);
            this.title(model.title);
            this.url(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getCollapseKey() {
            return this.collapseKey;
        }

        @Override
        public final Builder collapseKey(String collapseKey) {
            this.collapseKey = collapseKey;
            return this;
        }

        public final void setCollapseKey(String collapseKey) {
            this.collapseKey = collapseKey;
        }

        public final Map<String, String> getData() {
            return this.data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final String getIconReference() {
            return this.iconReference;
        }

        @Override
        public final Builder iconReference(String iconReference) {
            this.iconReference = iconReference;
            return this;
        }

        public final void setIconReference(String iconReference) {
            this.iconReference = iconReference;
        }

        public final String getImageIconUrl() {
            return this.imageIconUrl;
        }

        @Override
        public final Builder imageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
            return this;
        }

        public final void setImageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final String getRestrictedPackageName() {
            return this.restrictedPackageName;
        }

        @Override
        public final Builder restrictedPackageName(String restrictedPackageName) {
            this.restrictedPackageName = restrictedPackageName;
            return this;
        }

        public final void setRestrictedPackageName(String restrictedPackageName) {
            this.restrictedPackageName = restrictedPackageName;
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final String getSmallImageIconUrl() {
            return this.smallImageIconUrl;
        }

        @Override
        public final Builder smallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
            return this;
        }

        public final void setSmallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
        }

        public final String getSound() {
            return this.sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final Integer getTimeToLive() {
            return this.timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public GCMMessage build() {
            return new GCMMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GCMMessage> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder body(String var1);

        public Builder collapseKey(String var1);

        public Builder data(Map<String, String> var1);

        public Builder iconReference(String var1);

        public Builder imageIconUrl(String var1);

        public Builder imageUrl(String var1);

        public Builder priority(String var1);

        public Builder rawContent(String var1);

        public Builder restrictedPackageName(String var1);

        public Builder silentPush(Boolean var1);

        public Builder smallImageIconUrl(String var1);

        public Builder sound(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder timeToLive(Integer var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

