/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJourneysRequest extends PinpointRequest implements
        ToCopyableBuilder<ListJourneysRequest.Builder, ListJourneysRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJourneysRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<String> PAGE_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJourneysRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("page-size").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJourneysRequest::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            PAGE_SIZE_FIELD, TOKEN_FIELD));

    private final String applicationId;

    private final String pageSize;

    private final String token;

    private ListJourneysRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.pageSize = builder.pageSize;
        this.token = builder.token;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The maximum number of items to include in each page of a paginated response. This parameter is not supported for
     * application, campaign, and journey metrics.
     * </p>
     * 
     * @return The maximum number of items to include in each page of a paginated response. This parameter is not
     *         supported for application, campaign, and journey metrics.
     */
    public String pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The NextToken string that specifies which page of results to return in a paginated response.
     * </p>
     * 
     * @return The NextToken string that specifies which page of results to return in a paginated response.
     */
    public String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJourneysRequest)) {
            return false;
        }
        ListJourneysRequest other = (ListJourneysRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(token(), other.token());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListJourneysRequest").add("ApplicationId", applicationId()).add("PageSize", pageSize())
                .add("Token", token()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "Token":
            return Optional.ofNullable(clazz.cast(token()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJourneysRequest, T> g) {
        return obj -> g.apply((ListJourneysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListJourneysRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The maximum number of items to include in each page of a paginated response. This parameter is not supported
         * for application, campaign, and journey metrics.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to include in each page of a paginated response. This parameter is not
         *        supported for application, campaign, and journey metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(String pageSize);

        /**
         * <p>
         * The NextToken string that specifies which page of results to return in a paginated response.
         * </p>
         * 
         * @param token
         *        The NextToken string that specifies which page of results to return in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String pageSize;

        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJourneysRequest model) {
            super(model);
            applicationId(model.applicationId);
            pageSize(model.pageSize);
            token(model.token);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJourneysRequest build() {
            return new ListJourneysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
