/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies limits on the messages that a journey can send and the number of times participants can enter a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneyLimits implements SdkPojo, Serializable, ToCopyableBuilder<JourneyLimits.Builder, JourneyLimits> {
    private static final SdkField<Integer> DAILY_CAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JourneyLimits::dailyCap)).setter(setter(Builder::dailyCap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyCap").build()).build();

    private static final SdkField<Integer> ENDPOINT_REENTRY_CAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JourneyLimits::endpointReentryCap)).setter(setter(Builder::endpointReentryCap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointReentryCap").build())
            .build();

    private static final SdkField<Integer> MESSAGES_PER_SECOND_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JourneyLimits::messagesPerSecond)).setter(setter(Builder::messagesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagesPerSecond").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_CAP_FIELD,
            ENDPOINT_REENTRY_CAP_FIELD, MESSAGES_PER_SECOND_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dailyCap;

    private final Integer endpointReentryCap;

    private final Integer messagesPerSecond;

    private JourneyLimits(BuilderImpl builder) {
        this.dailyCap = builder.dailyCap;
        this.endpointReentryCap = builder.endpointReentryCap;
        this.messagesPerSecond = builder.messagesPerSecond;
    }

    /**
     * <p>
     * The maximum number of messages that the journey can send to a single participant during a 24-hour period. The
     * maximum value is 100.
     * </p>
     * 
     * @return The maximum number of messages that the journey can send to a single participant during a 24-hour period.
     *         The maximum value is 100.
     */
    public Integer dailyCap() {
        return dailyCap;
    }

    /**
     * <p>
     * The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow
     * participants to enter the journey an unlimited number of times, set this value to 0.
     * </p>
     * 
     * @return The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow
     *         participants to enter the journey an unlimited number of times, set this value to 0.
     */
    public Integer endpointReentryCap() {
        return endpointReentryCap;
    }

    /**
     * <p>
     * The maximum number of messages that the journey can send each second.
     * </p>
     * 
     * @return The maximum number of messages that the journey can send each second.
     */
    public Integer messagesPerSecond() {
        return messagesPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dailyCap());
        hashCode = 31 * hashCode + Objects.hashCode(endpointReentryCap());
        hashCode = 31 * hashCode + Objects.hashCode(messagesPerSecond());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyLimits)) {
            return false;
        }
        JourneyLimits other = (JourneyLimits) obj;
        return Objects.equals(dailyCap(), other.dailyCap()) && Objects.equals(endpointReentryCap(), other.endpointReentryCap())
                && Objects.equals(messagesPerSecond(), other.messagesPerSecond());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JourneyLimits").add("DailyCap", dailyCap()).add("EndpointReentryCap", endpointReentryCap())
                .add("MessagesPerSecond", messagesPerSecond()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DailyCap":
            return Optional.ofNullable(clazz.cast(dailyCap()));
        case "EndpointReentryCap":
            return Optional.ofNullable(clazz.cast(endpointReentryCap()));
        case "MessagesPerSecond":
            return Optional.ofNullable(clazz.cast(messagesPerSecond()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyLimits, T> g) {
        return obj -> g.apply((JourneyLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneyLimits> {
        /**
         * <p>
         * The maximum number of messages that the journey can send to a single participant during a 24-hour period. The
         * maximum value is 100.
         * </p>
         * 
         * @param dailyCap
         *        The maximum number of messages that the journey can send to a single participant during a 24-hour
         *        period. The maximum value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyCap(Integer dailyCap);

        /**
         * <p>
         * The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow
         * participants to enter the journey an unlimited number of times, set this value to 0.
         * </p>
         * 
         * @param endpointReentryCap
         *        The maximum number of times that a participant can enter the journey. The maximum value is 100. To
         *        allow participants to enter the journey an unlimited number of times, set this value to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointReentryCap(Integer endpointReentryCap);

        /**
         * <p>
         * The maximum number of messages that the journey can send each second.
         * </p>
         * 
         * @param messagesPerSecond
         *        The maximum number of messages that the journey can send each second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messagesPerSecond(Integer messagesPerSecond);
    }

    static final class BuilderImpl implements Builder {
        private Integer dailyCap;

        private Integer endpointReentryCap;

        private Integer messagesPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyLimits model) {
            dailyCap(model.dailyCap);
            endpointReentryCap(model.endpointReentryCap);
            messagesPerSecond(model.messagesPerSecond);
        }

        public final Integer getDailyCap() {
            return dailyCap;
        }

        @Override
        public final Builder dailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
            return this;
        }

        public final void setDailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
        }

        public final Integer getEndpointReentryCap() {
            return endpointReentryCap;
        }

        @Override
        public final Builder endpointReentryCap(Integer endpointReentryCap) {
            this.endpointReentryCap = endpointReentryCap;
            return this;
        }

        public final void setEndpointReentryCap(Integer endpointReentryCap) {
            this.endpointReentryCap = endpointReentryCap;
        }

        public final Integer getMessagesPerSecond() {
            return messagesPerSecond;
        }

        @Override
        public final Builder messagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
            return this;
        }

        public final void setMessagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
        }

        @Override
        public JourneyLimits build() {
            return new JourneyLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
