/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppsResponse extends PinpointResponse implements
        ToCopyableBuilder<GetAppsResponse.Builder, GetAppsResponse> {
    private static final SdkField<ApplicationsResponse> APPLICATIONS_RESPONSE_FIELD = SdkField
            .<ApplicationsResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetAppsResponse::applicationsResponse))
            .setter(setter(Builder::applicationsResponse))
            .constructor(ApplicationsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationsResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATIONS_RESPONSE_FIELD));

    private final ApplicationsResponse applicationsResponse;

    private GetAppsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationsResponse = builder.applicationsResponse;
    }

    /**
     * Returns the value of the ApplicationsResponse property for this object.
     * 
     * @return The value of the ApplicationsResponse property for this object.
     */
    public ApplicationsResponse applicationsResponse() {
        return applicationsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationsResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppsResponse)) {
            return false;
        }
        GetAppsResponse other = (GetAppsResponse) obj;
        return Objects.equals(applicationsResponse(), other.applicationsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAppsResponse").add("ApplicationsResponse", applicationsResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationsResponse":
            return Optional.ofNullable(clazz.cast(applicationsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppsResponse, T> g) {
        return obj -> g.apply((GetAppsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAppsResponse> {
        /**
         * Sets the value of the ApplicationsResponse property for this object.
         *
         * @param applicationsResponse
         *        The new value for the ApplicationsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationsResponse(ApplicationsResponse applicationsResponse);

        /**
         * Sets the value of the ApplicationsResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link ApplicationsResponse.Builder} avoiding the need
         * to create one manually via {@link ApplicationsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationsResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationsResponse(ApplicationsResponse)}.
         * 
         * @param applicationsResponse
         *        a consumer that will call methods on {@link ApplicationsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationsResponse(ApplicationsResponse)
         */
        default Builder applicationsResponse(Consumer<ApplicationsResponse.Builder> applicationsResponse) {
            return applicationsResponse(ApplicationsResponse.builder().applyMutation(applicationsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private ApplicationsResponse applicationsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppsResponse model) {
            super(model);
            applicationsResponse(model.applicationsResponse);
        }

        public final ApplicationsResponse.Builder getApplicationsResponse() {
            return applicationsResponse != null ? applicationsResponse.toBuilder() : null;
        }

        @Override
        public final Builder applicationsResponse(ApplicationsResponse applicationsResponse) {
            this.applicationsResponse = applicationsResponse;
            return this;
        }

        public final void setApplicationsResponse(ApplicationsResponse.BuilderImpl applicationsResponse) {
            this.applicationsResponse = applicationsResponse != null ? applicationsResponse.build() : null;
        }

        @Override
        public GetAppsResponse build() {
            return new GetAppsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
