/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSmsChannelRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateSmsChannelRequest.Builder, UpdateSmsChannelRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSmsChannelRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<SMSChannelRequest> SMS_CHANNEL_REQUEST_FIELD = SdkField
            .<SMSChannelRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateSmsChannelRequest::smsChannelRequest))
            .setter(setter(Builder::smsChannelRequest))
            .constructor(SMSChannelRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSChannelRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            SMS_CHANNEL_REQUEST_FIELD));

    private final String applicationId;

    private final SMSChannelRequest smsChannelRequest;

    private UpdateSmsChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.smsChannelRequest = builder.smsChannelRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the SMSChannelRequest property for this object.
     * 
     * @return The value of the SMSChannelRequest property for this object.
     */
    public SMSChannelRequest smsChannelRequest() {
        return smsChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(smsChannelRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmsChannelRequest)) {
            return false;
        }
        UpdateSmsChannelRequest other = (UpdateSmsChannelRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(smsChannelRequest(), other.smsChannelRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateSmsChannelRequest").add("ApplicationId", applicationId())
                .add("SMSChannelRequest", smsChannelRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "SMSChannelRequest":
            return Optional.ofNullable(clazz.cast(smsChannelRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmsChannelRequest, T> g) {
        return obj -> g.apply((UpdateSmsChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSmsChannelRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the SMSChannelRequest property for this object.
         *
         * @param smsChannelRequest
         *        The new value for the SMSChannelRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsChannelRequest(SMSChannelRequest smsChannelRequest);

        /**
         * Sets the value of the SMSChannelRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link SMSChannelRequest.Builder} avoiding the need to
         * create one manually via {@link SMSChannelRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link SMSChannelRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #smsChannelRequest(SMSChannelRequest)}.
         * 
         * @param smsChannelRequest
         *        a consumer that will call methods on {@link SMSChannelRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsChannelRequest(SMSChannelRequest)
         */
        default Builder smsChannelRequest(Consumer<SMSChannelRequest.Builder> smsChannelRequest) {
            return smsChannelRequest(SMSChannelRequest.builder().applyMutation(smsChannelRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private SMSChannelRequest smsChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmsChannelRequest model) {
            super(model);
            applicationId(model.applicationId);
            smsChannelRequest(model.smsChannelRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final SMSChannelRequest.Builder getSmsChannelRequest() {
            return smsChannelRequest != null ? smsChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder smsChannelRequest(SMSChannelRequest smsChannelRequest) {
            this.smsChannelRequest = smsChannelRequest;
            return this;
        }

        public final void setSmsChannelRequest(SMSChannelRequest.BuilderImpl smsChannelRequest) {
            this.smsChannelRequest = smsChannelRequest != null ? smsChannelRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmsChannelRequest build() {
            return new UpdateSmsChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
