/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveAttributesResponse extends PinpointResponse implements
        ToCopyableBuilder<RemoveAttributesResponse.Builder, RemoveAttributesResponse> {
    private static final SdkField<AttributesResource> ATTRIBUTES_RESOURCE_FIELD = SdkField
            .<AttributesResource> builder(MarshallingType.SDK_POJO)
            .getter(getter(RemoveAttributesResponse::attributesResource))
            .setter(setter(Builder::attributesResource))
            .constructor(AttributesResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesResource").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_RESOURCE_FIELD));

    private final AttributesResource attributesResource;

    private RemoveAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributesResource = builder.attributesResource;
    }

    /**
     * Returns the value of the AttributesResource property for this object.
     * 
     * @return The value of the AttributesResource property for this object.
     */
    public AttributesResource attributesResource() {
        return attributesResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributesResource());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveAttributesResponse)) {
            return false;
        }
        RemoveAttributesResponse other = (RemoveAttributesResponse) obj;
        return Objects.equals(attributesResource(), other.attributesResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemoveAttributesResponse").add("AttributesResource", attributesResource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributesResource":
            return Optional.ofNullable(clazz.cast(attributesResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveAttributesResponse, T> g) {
        return obj -> g.apply((RemoveAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, RemoveAttributesResponse> {
        /**
         * Sets the value of the AttributesResource property for this object.
         *
         * @param attributesResource
         *        The new value for the AttributesResource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesResource(AttributesResource attributesResource);

        /**
         * Sets the value of the AttributesResource property for this object.
         *
         * This is a convenience that creates an instance of the {@link AttributesResource.Builder} avoiding the need to
         * create one manually via {@link AttributesResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributesResource.Builder#build()} is called immediately and its
         * result is passed to {@link #attributesResource(AttributesResource)}.
         * 
         * @param attributesResource
         *        a consumer that will call methods on {@link AttributesResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributesResource(AttributesResource)
         */
        default Builder attributesResource(Consumer<AttributesResource.Builder> attributesResource) {
            return attributesResource(AttributesResource.builder().applyMutation(attributesResource).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private AttributesResource attributesResource;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveAttributesResponse model) {
            super(model);
            attributesResource(model.attributesResource);
        }

        public final AttributesResource.Builder getAttributesResource() {
            return attributesResource != null ? attributesResource.toBuilder() : null;
        }

        @Override
        public final Builder attributesResource(AttributesResource attributesResource) {
            this.attributesResource = attributesResource;
            return this;
        }

        public final void setAttributesResource(AttributesResource.BuilderImpl attributesResource) {
            this.attributesResource = attributesResource != null ? attributesResource.build() : null;
        }

        @Override
        public RemoveAttributesResponse build() {
            return new RemoveAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
