/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the conditions to evaluate for an event that applies to an activity in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventCondition implements SdkPojo, Serializable, ToCopyableBuilder<EventCondition.Builder, EventCondition> {
    private static final SdkField<EventDimensions> DIMENSIONS_FIELD = SdkField
            .<EventDimensions> builder(MarshallingType.SDK_POJO).getter(getter(EventCondition::dimensions))
            .setter(setter(Builder::dimensions)).constructor(EventDimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<String> MESSAGE_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventCondition::messageActivity)).setter(setter(Builder::messageActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageActivity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            MESSAGE_ACTIVITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final EventDimensions dimensions;

    private final String messageActivity;

    private EventCondition(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.messageActivity = builder.messageActivity;
    }

    /**
     * <p>
     * The dimensions for the event filter to use for the activity.
     * </p>
     * 
     * @return The dimensions for the event filter to use for the activity.
     */
    public EventDimensions dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The message identifier (message_id) for the message to use when determining whether message events meet the
     * condition.
     * </p>
     * 
     * @return The message identifier (message_id) for the message to use when determining whether message events meet
     *         the condition.
     */
    public String messageActivity() {
        return messageActivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(messageActivity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCondition)) {
            return false;
        }
        EventCondition other = (EventCondition) obj;
        return Objects.equals(dimensions(), other.dimensions()) && Objects.equals(messageActivity(), other.messageActivity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventCondition").add("Dimensions", dimensions()).add("MessageActivity", messageActivity())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "MessageActivity":
            return Optional.ofNullable(clazz.cast(messageActivity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventCondition, T> g) {
        return obj -> g.apply((EventCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventCondition> {
        /**
         * <p>
         * The dimensions for the event filter to use for the activity.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the event filter to use for the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(EventDimensions dimensions);

        /**
         * <p>
         * The dimensions for the event filter to use for the activity.
         * </p>
         * This is a convenience that creates an instance of the {@link EventDimensions.Builder} avoiding the need to
         * create one manually via {@link EventDimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventDimensions.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(EventDimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link EventDimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(EventDimensions)
         */
        default Builder dimensions(Consumer<EventDimensions.Builder> dimensions) {
            return dimensions(EventDimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * The message identifier (message_id) for the message to use when determining whether message events meet the
         * condition.
         * </p>
         * 
         * @param messageActivity
         *        The message identifier (message_id) for the message to use when determining whether message events
         *        meet the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageActivity(String messageActivity);
    }

    static final class BuilderImpl implements Builder {
        private EventDimensions dimensions;

        private String messageActivity;

        private BuilderImpl() {
        }

        private BuilderImpl(EventCondition model) {
            dimensions(model.dimensions);
            messageActivity(model.messageActivity);
        }

        public final EventDimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(EventDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(EventDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final String getMessageActivity() {
            return messageActivity;
        }

        @Override
        public final Builder messageActivity(String messageActivity) {
            this.messageActivity = messageActivity;
            return this;
        }

        public final void setMessageActivity(String messageActivity) {
            this.messageActivity = messageActivity;
        }

        @Override
        public EventCondition build() {
            return new EventCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
