/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVoiceTemplateRequest extends PinpointRequest implements
        ToCopyableBuilder<DeleteVoiceTemplateRequest.Builder, DeleteVoiceTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteVoiceTemplateRequest::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("template-name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteVoiceTemplateRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            VERSION_FIELD));

    private final String templateName;

    private final String version;

    private DeleteVoiceTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of the message template. A template name must start with an alphanumeric character and can contain a
     * maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-).
     * Template names are case sensitive.
     * </p>
     * 
     * @return The name of the message template. A template name must start with an alphanumeric character and can
     *         contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or
     *         hyphens (-). Template names are case sensitive.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The unique identifier for the version of the message template to update, retrieve information about, or delete.
     * To retrieve identifiers and other information for all the versions of a template, use the <link
     * linkend="templates-template-name-template-type-versions">Template Versions</link> resource.
     * </p>
     * <p>
     * If specified, this value must match the identifier of an existing template version. If specified for an update
     * operation, this value must match the identifier of the latest existing version of the template. This restriction
     * helps ensure that race conditions don't occur.
     * </p>
     * <p>
     * If you don't specify a value for this parameter, Amazon Pinpoint does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a get operation, retrieves information about the active version of the template.
     * </p>
     * </li>
     * <li>
     * <p>
     * For an update operation, saves the updates to the latest existing version of the template, if the
     * create-new-version parameter isn't used or is set to false.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a delete operation, deletes the template, including all versions of the template.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The unique identifier for the version of the message template to update, retrieve information about, or
     *         delete. To retrieve identifiers and other information for all the versions of a template, use the <link
     *         linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
     *         <p>
     *         If specified, this value must match the identifier of an existing template version. If specified for an
     *         update operation, this value must match the identifier of the latest existing version of the template.
     *         This restriction helps ensure that race conditions don't occur.
     *         </p>
     *         <p>
     *         If you don't specify a value for this parameter, Amazon Pinpoint does the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For a get operation, retrieves information about the active version of the template.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For an update operation, saves the updates to the latest existing version of the template, if the
     *         create-new-version parameter isn't used or is set to false.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For a delete operation, deletes the template, including all versions of the template.
     *         </p>
     *         </li>
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVoiceTemplateRequest)) {
            return false;
        }
        DeleteVoiceTemplateRequest other = (DeleteVoiceTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteVoiceTemplateRequest").add("TemplateName", templateName()).add("Version", version())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVoiceTemplateRequest, T> g) {
        return obj -> g.apply((DeleteVoiceTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVoiceTemplateRequest> {
        /**
         * <p>
         * The name of the message template. A template name must start with an alphanumeric character and can contain a
         * maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-).
         * Template names are case sensitive.
         * </p>
         * 
         * @param templateName
         *        The name of the message template. A template name must start with an alphanumeric character and can
         *        contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_),
         *        or hyphens (-). Template names are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The unique identifier for the version of the message template to update, retrieve information about, or
         * delete. To retrieve identifiers and other information for all the versions of a template, use the <link
         * linkend="templates-template-name-template-type-versions">Template Versions</link> resource.
         * </p>
         * <p>
         * If specified, this value must match the identifier of an existing template version. If specified for an
         * update operation, this value must match the identifier of the latest existing version of the template. This
         * restriction helps ensure that race conditions don't occur.
         * </p>
         * <p>
         * If you don't specify a value for this parameter, Amazon Pinpoint does the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For a get operation, retrieves information about the active version of the template.
         * </p>
         * </li>
         * <li>
         * <p>
         * For an update operation, saves the updates to the latest existing version of the template, if the
         * create-new-version parameter isn't used or is set to false.
         * </p>
         * </li>
         * <li>
         * <p>
         * For a delete operation, deletes the template, including all versions of the template.
         * </p>
         * </li>
         * </ul>
         * 
         * @param version
         *        The unique identifier for the version of the message template to update, retrieve information about,
         *        or delete. To retrieve identifiers and other information for all the versions of a template, use the
         *        <link linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
         *        <p>
         *        If specified, this value must match the identifier of an existing template version. If specified for
         *        an update operation, this value must match the identifier of the latest existing version of the
         *        template. This restriction helps ensure that race conditions don't occur.
         *        </p>
         *        <p>
         *        If you don't specify a value for this parameter, Amazon Pinpoint does the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For a get operation, retrieves information about the active version of the template.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For an update operation, saves the updates to the latest existing version of the template, if the
         *        create-new-version parameter isn't used or is set to false.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For a delete operation, deletes the template, including all versions of the template.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String templateName;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVoiceTemplateRequest model) {
            super(model);
            templateName(model.templateName);
            version(model.version);
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVoiceTemplateRequest build() {
            return new DeleteVoiceTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
